/********************************************************************** 
 * Copyright (c) 2010 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: SelectAllAction.java,v 1.1 2010/03/30 15:15:29 paules Exp $ 
 * 
 * Contributors: 
 * 		IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.action;

import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolTable;
import org.eclipse.hyades.test.ui.internal.editor.DatapoolEditorPart;
import org.eclipse.hyades.test.ui.internal.editor.extension.DatapoolEditorExtension;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.ui.IWorkbenchCommandConstants;
import org.eclipse.ui.PlatformUI;

/** 
 * <p>Select all action for the datapool table.</p>
 * 
 * 
 * @author  Paul Slauenwhite
 * @version March 30, 2010
 * @since   March 30, 2010
 */
public class SelectAllAction extends org.eclipse.hyades.ui.internal.editor.action.SelectAllAction {

	private DatapoolTable table = null;

	public SelectAllAction() {
		this(null);
	}

	public SelectAllAction(DatapoolTable table) {

		super();

		this.table = table;

		setText(UiPluginResourceBundle.SELECT_ALL_TEXT); 
		setDescription(UiPluginResourceBundle.SELECT_ALL_LDESC);

		this.setId(this.getClass().getName());
		this.setActionDefinitionId(IWorkbenchCommandConstants.EDIT_SELECT_ALL);

		UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this, UiPlugin.getID() + ContextIds.SELECT_ALL_ACT);        
	}

	public void run() {

		if (getFocusControl() instanceof TableCursor) {

			if(table != null){
				table.selectAll();
			}
			else{

				DatapoolEditorPart activeEditor = (DatapoolEditorPart) PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
				DatapoolTable currentTable = ((DatapoolEditorExtension) activeEditor.getEditorExtension()).getCurrentDatapoolTable();

				if (currentTable != null){
					currentTable.selectAll();
				}
			}
		} 
		else if (isValidFocusControl()){
			super.run();
		}
	}

	public void setTable(DatapoolTable table){
		this.table = table;
	}
}
