/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DatapoolAddDialogSimple.java,v 1.5 2007/03/22 14:42:05 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.dialog;

import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

/**
 * @author psun
 *
 */
public class DatapoolAddDialogSimple extends DatapoolBaseDialog implements SelectionListener {

	//private static final int HEIGHT = 40;
	//private static final int WIDTH = 120;

	private Button addBeforeButton = null;
	private Button addAfterButton = null;
	private String title = null;
	private int indexAdjustment = 0;
	
	/**
	 * @param parentShell
	 */
	public DatapoolAddDialogSimple(Shell parentShell, String title) 
	{
		super(parentShell);
		this.title = title;
	}
	
	/**
	 * @see org.eclipse.jface.window.Window#createContents(org.eclipse.swt.widgets.Composite)
	 */
	protected Control createContents(Composite parent)
	{
		Control control = super.createContents(parent);
		return control;
	}

	/**
	 * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	protected Control createDialogArea(Composite parent)
	{
		getShell().setText(title);
		Composite superComposite = (Composite)super.createDialogArea(parent);
		GridData gridData = GridDataUtil.createFill();
		superComposite.setLayoutData(gridData);		

		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 1;
		superComposite.setLayout(gridLayout);
		
		addBeforeButton = new Button(superComposite, SWT.RADIO);
		addBeforeButton.setText(UiPluginResourceBundle.DATA_ADD_ROW_OPTION_BEFORE); 
		addBeforeButton.setSelection(false);
		addBeforeButton.addSelectionListener(this);
		
		addAfterButton = new Button(superComposite, SWT.RADIO);
		addAfterButton.setText(UiPluginResourceBundle.DATA_ADD_ROW_OPTION_AFTER); 
		addAfterButton.setSelection(true);
		addAfterButton.addSelectionListener(this);
		
		return superComposite;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) 
	{
		Button button = (Button)e.widget;
		if(button.equals(addBeforeButton))
		{
			button.setSelection(true);
			addAfterButton.setSelection(false);
			indexAdjustment = -1;
		}
		if(button.equals(addAfterButton))
		{
			button.setSelection(true);
			addBeforeButton.setSelection(false);
			indexAdjustment = 0;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) 
	{
		return;
	}
	
	public int getIndexAdjustment()
	{
		return indexAdjustment;
	}
	
}
