/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DatapoolBaseDialog.java,v 1.6 2009/10/29 13:41:01 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.dialog;

import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/**
 * <p>A base dialog for all datapool dialogs.</p> 
 * 
 * <p>This base dialog is resizeable, contains 
 * ? (help), OK (default), and Cancel buttons, and 
 * is configured for context sensitive help 
 * (see {@link ContextIds#DATA_BASE_DIALOG}).</p>
 * 
 * 
 * @author  Bianca Xue Jiang
 * @author  Paul Slauenwhite
 * @version October 28, 2009
 * @since   January 27, 2005
 * @see     TrayDialog
 */
public class DatapoolBaseDialog extends TrayDialog {
	
	/**
	 * Single argument constructor.
	 * 
	 * @param parentShell The parent shell.
	 */
	public DatapoolBaseDialog(Shell parentShell) {
		
		super(parentShell);
		
		setShellStyle(getShellStyle() | SWT.RESIZE);
		
		setHelpAvailable(true);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	protected Control createDialogArea(Composite parent){
		
		//Set the context sensitive help:
		PlatformUI.getWorkbench().getHelpSystem().setHelp(parent, UiPlugin.getID() + ContextIds.DATA_BASE_DIALOG);
		
		return (super.createDialogArea(parent));
	}
}
