/********************************************************************** 
 * Copyright (c) 2008, 2010 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: DatapoolChangeKeyDialog.java,v 1.5 2010/02/03 13:58:57 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.dialog;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.models.common.datapool.util.DatapoolEncryptManager;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/**
 * <p>Dialog for changing the password for the datpaool.</p>
 * 

 * @author  Huang Xin Ying
 * @author  Paul Slauenwhite
 * @version February 3, 2010
 * @since   March 20, 2008
 */
public class DatapoolChangeKeyDialog extends DatapoolBaseDialog {

	private IDatapool datapool = null;
	private boolean isChangeMode = false;

	private String oldKey = null;
	private String newKey = null;
	private String confirmKey = null;
	
	private Label errorLabel = null;
	
	public DatapoolChangeKeyDialog(Shell parentShell, IDatapool datapool, boolean isChangeMode) {
		
		super(parentShell);
		
		this.datapool = datapool;
		this.isChangeMode = isChangeMode;
	}
	
	public String getOldKey() {
		return oldKey;
	}

	public String getNewKey() {
		return newKey;
	}

	public String getConfirmKey() {
		return confirmKey;
	}	
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#createButtonsForButtonBar(org.eclipse.swt.widgets.Composite)
	 */
	protected void createButtonsForButtonBar(Composite parent) {
		
		super.createButtonsForButtonBar(parent);

		getButton(IDialogConstants.OK_ID).setEnabled(false);
	}	

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolBaseDialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	protected Control createDialogArea(Composite parent) {
		
		if(isChangeMode){
			getShell().setText(UiPluginResourceBundle.DatapoolDialog_MODIFYPASSWORDDIALOGTITLE);
		}
		else{
			getShell().setText(UiPluginResourceBundle.DatapoolDialog_ASSIGNKEYDIALOGTITLE);
		}
		
		GridData gridData = GridDataUtil.createFill();
		gridData.minimumWidth = 300;
		
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;

		Composite parentComposite = ((Composite)(super.createDialogArea(parent)));
		parentComposite.setLayoutData(gridData);
		parentComposite.setLayout(gridLayout);
		
		if (isChangeMode) {
			
			Label oldKeyLabel = new Label(parentComposite, SWT.NONE);
			oldKeyLabel.setText(UiPluginResourceBundle.DatapoolDialog_OLDKEY);
			
			final Text oldKeyText = new Text(parentComposite, SWT.SINGLE | SWT.BORDER | SWT.PASSWORD);
			oldKeyText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			oldKeyText.addModifyListener(new ModifyListener() {
				
				/* (non-Javadoc)
				 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
				 */
				public void modifyText(ModifyEvent e) {		
					
					oldKey = oldKeyText.getText();
					
					enableOK();
				}
			});
		}
		
		Label newKeyLabel = new Label(parentComposite, SWT.NONE);
		newKeyLabel.setText(UiPluginResourceBundle.DatapoolDialog_NEWKEY);
		
		final Text newKeyText = new Text(parentComposite, SWT.SINGLE | SWT.BORDER | SWT.PASSWORD);
		newKeyText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		newKeyText.addModifyListener(new ModifyListener() {
			
			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
			 */
			public void modifyText(ModifyEvent e) {		
				
				newKey = newKeyText.getText();
				
				enableOK();
			}
		});

		Label confirmKeyLabel = new Label(parentComposite, SWT.NONE);
		confirmKeyLabel.setText(UiPluginResourceBundle.DatapoolDialog_CONFIRMNEWKEY);

		final Text confirmKeyText = new Text(parentComposite, SWT.SINGLE | SWT.BORDER | SWT.PASSWORD);
		confirmKeyText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		
		confirmKeyText.addModifyListener(new ModifyListener() {
			
			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
			 */
			public void modifyText(ModifyEvent e) {		
				
				confirmKey = confirmKeyText.getText();
				
				enableOK();
			}
		});
		
		gridData = new GridData(GridData.FILL_HORIZONTAL);
		gridData.horizontalSpan = 2;

		//Note: Set the text of the error label to the longest possible string for layout purposes.
		errorLabel = new Label(parentComposite,SWT.NONE);
		errorLabel.setText(UiPluginResourceBundle.DatapoolDialog_NEWKEYNOTCONFIRMMES);
		errorLabel.setLayoutData(gridData);
		errorLabel.setForeground(Display.getDefault().getSystemColor(SWT.COLOR_RED));
		errorLabel.setVisible(false);
		
		parentComposite.pack();
		
		return parentComposite;
	}
	
	private void enableOK(){
		
		boolean enableOK = true;
		
		//Validate if the old key exists and is correct:
		if((isChangeMode) && ((oldKey == null) || (oldKey.equals("")) || (!DatapoolEncryptManager.isKeyCorrect(datapool, oldKey)))){		

			enableOK = false;	

			errorLabel.setText(UiPluginResourceBundle.DatapoolDialog_ORIGINKEYERRORMES);
		}

		//Validate if the new key exists:
		else if((newKey == null) || (newKey.equals(""))){			
			
			enableOK = false;
			
			errorLabel.setText(UiPluginResourceBundle.DatapoolDialog_NEWKEYEMPTYMES);
		}
		
		//Validate if the confirm key exists and is the same as the new key:
		else if ((confirmKey == null) || (confirmKey.equals("")) || (!newKey.equals(getConfirmKey()))) {

			enableOK = false;	

			errorLabel.setText(UiPluginResourceBundle.DatapoolDialog_NEWKEYNOTCONFIRMMES);
		}		
		
		errorLabel.setVisible(!enableOK);

		getButton(IDialogConstants.OK_ID).setEnabled(enableOK);
	}
}
