/********************************************************************** 
 * Copyright (c) 2010 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: DatapoolConstants.java,v 1.1 2010/03/31 19:18:08 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.ui.datapool.internal.dialog;

import org.eclipse.hyades.test.ui.util.TestUIUtil;

/**
 * <p>Datapool constants.</p>
 * 
 * 
 * @author  Paul Slauenwhite 
 * @version March 31, 2010
 * @since   March 31, 2010
 */
public class DatapoolConstants {
		
	/**
	 * <p>Delimiter for concatenating a datapool variable name and type (value is <code>::</code>).</p>
	 */
	public static final String VARIABLE_NAME_TYPE_DELIMITER = "::";  

	/**
	 * System variable (<code>DISABLE_DATAPOOL_LIMITS</code>) for disabling the datapool limits.
	 * 
	 * @see #MAXIMUM_VARIABLE_LIMIT
	 */
	public static final boolean DISABLE_DATAPOOL_LIMITS = Boolean.getBoolean("DISABLE_DATAPOOL_LIMITS");
	
	/**
	 * <p>Datapool variable limit.</p>
	 * 
	 * <p>If the current platform is Windows and the <code>DISABLE_DATAPOOL_LIMITS</code> system property is 
	 * <b>not</b> set or <code>false</code>, the variable limit is 256, otherwise {@link Integer#MAX_VALUE}.</p>
	 * 
	 * @see #DISABLE_DATAPOOL_LIMITS
	 * @see TestUIUtil#IS_WINDOWS_OS
	 */
	public static final int MAXIMUM_VARIABLE_LIMIT = (((TestUIUtil.IS_WINDOWS_OS) && (!DISABLE_DATAPOOL_LIMITS)) ? 256: Integer.MAX_VALUE);
}
