/********************************************************************** 
 * Copyright (c) 2008, 2009 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: DatapoolInputKeyDialog.java,v 1.5 2009/10/29 16:30:21 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.dialog;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.models.common.datapool.util.DatapoolEncryptManager;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/**
 * <p>Dialog for entering the password for the datpaool.</p>
 * 
 * 
 * @author  Huang Xin Ying
 * @author  Paul Slauenwhite
 * @version October 29, 2009
 * @since   March 20, 2008
 */
public class DatapoolInputKeyDialog extends DatapoolBaseDialog{

	private IDatapool datapool = null;

	private String key = null;

	private Label errorLabel = null;

	public DatapoolInputKeyDialog(Shell parentShell, IDatapool datapool) {

		super(parentShell);

		this.datapool = datapool;		
	}

	public String getKey() {
		return key;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#createButtonsForButtonBar(org.eclipse.swt.widgets.Composite)
	 */
	protected void createButtonsForButtonBar(Composite parent) {

		super.createButtonsForButtonBar(parent);

		getButton(IDialogConstants.OK_ID).setEnabled(false);
	}	

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolBaseDialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	protected Control createDialogArea(Composite parent) {

		getShell().setText(UiPluginResourceBundle.DatapoolDialog_INPUTKEYDIALGOTITLE);

		GridData gridData = GridDataUtil.createFill();
		gridData.minimumWidth = 300;
		
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;

		Composite parentComposite = ((Composite)(super.createDialogArea(parent)));
		parentComposite.setLayoutData(gridData);
		parentComposite.setLayout(gridLayout);

		Label keyLabel = new Label(parentComposite, SWT.NONE);
		keyLabel.setText(UiPluginResourceBundle.DatapoolDialog_INPUTKEYLABEL);

		final Text keyText = new Text(parentComposite, SWT.SINGLE | SWT.BORDER | SWT.PASSWORD);
		keyText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		keyText.addModifyListener(new ModifyListener() {

			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
			 */
			public void modifyText(ModifyEvent e) {		

				key = keyText.getText();

				enableOK();
			}
		});

		gridData = new GridData(GridData.FILL_HORIZONTAL);
		gridData.horizontalSpan = 2;

		//Note: Set the text of the error label to the longest possible string for layout purposes.
		errorLabel = new Label(parentComposite,SWT.NONE);
		errorLabel.setText(UiPluginResourceBundle.DatapoolDialog_WRONGLOGONKEYMES);
		errorLabel.setLayoutData(gridData);
		errorLabel.setForeground(Display.getDefault().getSystemColor(SWT.COLOR_RED));
		errorLabel.setVisible(false);

		parentComposite.pack();

		return parentComposite;
	}

	private void enableOK(){

		boolean enableOK = true;

		//Validate if the key exists and is correct:
		if((key == null) || (key.equals("")) || (!DatapoolEncryptManager.isKeyCorrect(datapool,key))){			

			enableOK = false;

			errorLabel.setText(UiPluginResourceBundle.DatapoolDialog_WRONGLOGONKEYMES);
		}	

		errorLabel.setVisible(!enableOK);

		getButton(IDialogConstants.OK_ID).setEnabled(enableOK);
	}
}
