/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDatapoolPart.java,v 1.2 2005/02/25 22:17:54 hleung Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.interfaces;

import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.ui.IActionBars;

/**
 * @author psun
 */
public interface IDatapoolPart {

	/**
	 * Marks the editor as dirty.
	 */
	public void markDirty();
	
	/**
	 * Returns whether the content of this part is read only.
	 * 
	 * @return boolean
	 */
	public boolean isReadOnly();

	/**
	 * Returns the clipboard associated with this part.
	 * 
	 * @return Clipboard
	 */
	public Clipboard getClipboard();

	/**
	 * Returns the action bar associated with this part.
	 * 
	 * @return IActionBars
	 */
	public IActionBars getActionBars();
	
	/**
	 * Notifes the part that an edit action has occured.
	 *
	 */
	public void notifyEdit();
	
}
