/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CSVBufferedReader.java,v 1.3 2005/12/27 05:25:17 bjiang Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.util;

import java.io.*;


/**
 * @author psun
 * @author bjiang
 */
public class CSVBufferedReader extends BufferedReader {

	public static final String LINE_SEPARATOR = System.getProperty("line.separator");
	
	/**
	 * @param in
	 */
	public CSVBufferedReader(Reader in) 
	{
		super(in);
	}
	
	public String readLine() throws IOException
	{
		// https://bugs.eclipse.org/bugs/show_bug.cgi?id=117932
		// performance optimization
		String line = super.readLine();
		if(line != null && line.startsWith(CSVTokenizer.DOUBLEQUOTE))
		{
			String searchLine = line.substring(1, line.length());
			while(!findEndingQuote(searchLine))
			{
				searchLine = super.readLine();
				if(searchLine == null)
					break;
				line += LINE_SEPARATOR + searchLine;
			}
		}
		
		return line;
	}	
	
	private boolean findEndingQuote(String line)
	{
		line = line.replaceAll(CSVTokenizer.TWO_DOUBLEQUOTES, "");
		return (line.indexOf(CSVTokenizer.DOUBLEQUOTE) > -1);
	}
}
