/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CSVTokenizer.java,v 1.8 2010/03/31 19:18:06 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.util;

import java.util.Enumeration;

/**
 * <p>CSV file tokenizer.</p>
 * 
 * 
 * @author  Peter Sun
 * @author  Bianca Xue Jiang
 * @author  Paul E. Slauenwhite
 * @version March 31, 2010
 * @since   January 27, 2005
 */
public class CSVTokenizer implements Enumeration{
	
	public static final String COMMA = ","; //$NON-NLS-1$
	public static final String TWO_DOUBLEQUOTES = "\"\""; //$NON-NLS-1$
	public static final String DOUBLEQUOTE = "\""; //$NON-NLS-1$
	private static final String TWOQUOTES_SUB = "\u0000\u0000"; //$NON-NLS-1$
		
	String input = null;
	String nextToken = null;
	
	public CSVTokenizer(String input)
	{
		this.input = input;
		setNextToken();
	}

	public String currentToken()
	{
		return nextToken;	
	}

	public String nextToken()
	{
		String returnToken = nextToken;
		setNextToken();
		return returnToken;	
	}
	
	private void setNextToken()
	{
		// https://bugs.eclipse.org/bugs/show_bug.cgi?id=117932
		// performance optimization
		if(input == null){
			nextToken = null;
			return;
		}
		
		if(input.startsWith(DOUBLEQUOTE))
		{
			input = input.substring(1);
			String searchString = input.replaceAll(TWO_DOUBLEQUOTES, TWOQUOTES_SUB); //
			int endQuoteIndex = searchString.indexOf(DOUBLEQUOTE); //
			
			if(endQuoteIndex == -1)
			{
				nextToken = searchString.replaceAll(TWOQUOTES_SUB, DOUBLEQUOTE); //
				input = null;
			}
			else
			{
				int commaIndex = searchString.indexOf(COMMA, (endQuoteIndex + 1));
				if(commaIndex == -1)
				{
					nextToken = searchString.substring(0, endQuoteIndex).replaceAll(TWOQUOTES_SUB, DOUBLEQUOTE);//
					nextToken += input.substring((endQuoteIndex + 1), input.length());
					input = null;
				}
				else
				{
					nextToken = searchString.substring(0, endQuoteIndex).replaceAll(TWOQUOTES_SUB, DOUBLEQUOTE);//
					nextToken += input.substring((endQuoteIndex + 1), commaIndex);
					input = input.substring((commaIndex + 1), input.length()); //
				}
			}
		}
		else
		{
			int i = input.indexOf(COMMA);
			if(i == -1)
			{
				nextToken = input;
				input = null;
			}
			else
			{
				nextToken = input.substring(0, i);
				input  = input.substring((i + 1), input.length());
			}
		}
	}
	
	public boolean hasMoreTokens()
	{
		if(nextToken != null)
			return true;
		else
			return false;
	}

	public boolean hasMoreElements() {
		return hasMoreTokens();
	}

	public Object nextElement() {
		return nextToken();
	}
	
	public static int countTokens(String string, String token){
		
		int tokenCount = 0;
		int tokenIndex = string.indexOf(token);
		
		while(tokenIndex != -1){
			
			tokenCount++;
			
			tokenIndex = string.indexOf(token, (tokenIndex + token.length()));
		}
		
		return tokenCount;	
	}
}
