/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DatapoolUtil.java,v 1.11 2008/11/03 13:35:43 bjerome Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.util;

import java.util.ArrayList;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolSuggestedType;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.models.common.datapool.DPLVariable;

/**
 * DatapoolUtil.java
 * <p/>
 * 
 * 
 * @author  Peter Sun
 * @author  Paul E. Slauenwhite
 * @author jbozier
 * @version October 7, 2008
 * @since   January 27, 2005
 */
public class DatapoolUtil 
{
	private static final DatapoolUtil instance = new DatapoolUtil();
	
	public static DatapoolUtil getInstance()
	{
		return instance;
	}
	
	protected DatapoolUtil()
	{
	}

	public IDatapoolVariable[] getVariables(IDatapool datapool, String exclusionName)
	{
		if(datapool == null)
			return null;
		int variableCount = datapool.getVariableCount();
		ArrayList tempList = new ArrayList();
		for(int i = 0; i < variableCount; i++)
		{
			IDatapoolVariable variable = (IDatapoolVariable)datapool.getVariable(i);
			String variableName = variable.getName();
			if(variableName.equals(exclusionName))
				continue;
			else
				tempList.add(variable);
		}

		int listSize = tempList.size();
		IDatapoolVariable[] returnList = new IDatapoolVariable[listSize];
		tempList.toArray(returnList);
		return returnList;
	}
		
	public IDatapoolEquivalenceClass[] getEquivalenceClasses(IDatapool datapool, String exclusionID)
	{
		if(datapool == null)
			return null;
		int equivalenceClassCount = datapool.getEquivalenceClassCount();
		ArrayList tempList = new ArrayList();
		for(int i = 0; i < equivalenceClassCount; i++)
		{
			IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(i);
			String equivalenceClassID = equivalenceClass.getId();
			if(equivalenceClassID.equals(exclusionID))
				continue;
			else
				tempList.add(equivalenceClass);
		}
		int listSize = tempList.size();
		IDatapoolEquivalenceClass[] returnList = new IDatapoolEquivalenceClass[listSize];
		tempList.toArray(returnList);
		return returnList;
	}

	/**
	 * Resolves the type string (see {@link IDatapoolSuggestedType}) of the parameter datapool 
	 * variable or an empty string if the parameter variable is <code>null</code>.
	 * <p/>
	 * 
	 * 
	 * @param variable The datapool variable. 
	 * @return The type string of the parameter datapool, otherwise an empty string.
	 * @see IDatapoolSuggestedType
	 */
    public String getVariableTypeInfo(IDatapoolVariable variable)
    {
    	if(variable == null){
    		return "";
    	}
    	
    	if(variable instanceof DPLVariable)
    		return ((DPLVariable)variable).getType();
    	
        String type = new String();
        IDatapoolSuggestedType suggestedType = (IDatapoolSuggestedType)variable.getSuggestedType();
        if(suggestedType != null)
        {
        	String className = suggestedType.getSuggestedClassName();
        	if(className != null && className.length() > 0)
        	    type = className;
        	else
        	{
        	    switch(suggestedType.getSuggestedType())
        	    {
        	        case IDatapoolSuggestedType.TYPE_BOOLEAN:
        	            type = IDatapoolSuggestedType.TYPE_DISPLAY_BOOLEAN;
        	        	break;
        	        case IDatapoolSuggestedType.TYPE_NUMBER:
        	            type = IDatapoolSuggestedType.TYPE_DISPLAY_NUMBER;
        	        	break;
        	        case IDatapoolSuggestedType.TYPE_ENUMERATION:
        	            type = IDatapoolSuggestedType.TYPE_DISPLAY_ENUMERATION;
        	        	break;
        	        case IDatapoolSuggestedType.TYPE_COMPLEX:
        	            type = IDatapoolSuggestedType.TYPE_DISPLAY_COMPLEX;
        	        	break;
        	        case IDatapoolSuggestedType.TYPE_STRING:
        	        default:
        	            type = IDatapoolSuggestedType.TYPE_DISPLAY_STRING;
        	        	break;
        	    }
        	}
        }
        return type;
    }
}
