/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: EncryptedStringValueClass.java,v 1.1 2008/03/20 17:48:10 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.ui.datapool.internal.util;

import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

/**
 * @author Huang Xin Ying 
 * @version February 27, 2008
 */
public class EncryptedStringValueClass extends StringValueClass{
	/**
	 * Return the cell editor or label for encrypted cell object .
	 * @param theObject
	 * @param parent
	 * @param editable
	 * @return Object
	 */
	public Object getPropertyDisplay(Object theObject, Composite parent, boolean editable)
	{
		if(editable && theObject != null)
		{
			TextCellEditor cellEditor = new TextCellEditor(parent,SWT.PASSWORD);

			cellEditor.setValue(theObject.toString());
			return cellEditor;
		}
		else
		{
			Label label = new Label(parent, SWT.NONE);
			label.setText(getPropertyDescription(theObject));
			return label;
		}
	}

}
