/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ValueClassMap.java,v 1.8 2010/03/03 21:19:40 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.util;

import java.util.HashMap;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDisplayValueClass;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IValidateValueClass;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IValueClassFactory;

/**
 * <p>ValueClassMap.java</p>
 * 
 * 
 * @author  Peter Sun
 * @author  Paul Slauenwhite
 * @version March 3, 2010
 * @since   January 27, 2005
 */
public class ValueClassMap {

	private static HashMap displayMap = loadDisplayClassMap();
	private static HashMap validatorMap = loadValidatorClassMap();
	private static HashMap valueFactoryMap = loadValueFactoryMap();
	private static String mapVendorID = null;

	public static IDisplayValueClass getSWTValueDisplayClass(Object theObject)
	{
		if ( theObject == null ) return null;
		Class cls = theObject.getClass();
		return getValueDisplayClass(cls);
	}

	public static IValidateValueClass getValueValidatorClass(Object theObject)
	{
		if ( theObject == null ) return null;
		Class cls = theObject.getClass();
		return getValidatorClass(cls);
	}

	public static IValidateValueClass getValueValidatorClass(String theObjectClassName)
	{
		if ( theObjectClassName == null ) return null;
		return getValidatorClass(theObjectClassName);
	}
	
	public static IValueClassFactory getValueClassFactory(String theObjectClassName)
	{
		if ( theObjectClassName == null ) return null;
		return getClassFactory(theObjectClassName);
	}
	
	public static void setVendorID(String vendorID)
	{
		mapVendorID = vendorID;
	}
	
	private static IDisplayValueClass getValueDisplayClass(Class cls){
		
		if(cls != null){

			Object displayValueClass = null;
			
			//Optimization for when no display classes are registered:
			if(displayMap.size() > 0){

				displayValueClass = displayMap.get(cls.getName());
			
				Class keyClass = cls;
	
				while((displayValueClass == null) && ((keyClass = keyClass.getSuperclass()) != null)){			
					displayValueClass = displayMap.get(keyClass.getName());
				}
			}
			
			if((displayValueClass == null) && (cls.equals(String.class))){ 
				return (new StringValueClass());
			}
			
			return ((IDisplayValueClass)(displayValueClass));
		}
		
		return null;
	}
	
//	private static IDisplayValueClass getValueDisplayClass(String className)
//	{
//		if(className == null) return null;
//		//loadDisplayClassMap();
//		Object result = displayMap.get(className);
//		if(result == null && className.equals("java.lang.String")) //$NON-NLS-1$
//			result = new StringValueClass();
//		return (IDisplayValueClass)result;		
//	}
	
	private static IValidateValueClass getValidatorClass(Class cls)
	{
		if(cls == null) return null;
		String cl = cls.getName();
		//loadValidatorClassMap();
		Object result = validatorMap.get(cl);
		if(result == null)
			result = getValidatorClass(cls.getSuperclass());
		if(result == null && cl.equals("java.lang.String")) //$NON-NLS-1$
			result = new StringValidatorValueClass();
		return (IValidateValueClass)result;		
	}

	private static IValidateValueClass getValidatorClass(String className)
	{
		if(className == null) return null;
		//loadDisplayClassMap();
		Object result = validatorMap.get(className);
		if(result == null && className.equals("java.lang.String")) //$NON-NLS-1$
			result = new StringValidatorValueClass();
		return (IValidateValueClass)result;		
	}

	private static IValueClassFactory getClassFactory(String className)
	{
		if(className == null) return null;
		//loadValueFactoryMap();
		Object result = valueFactoryMap.get(className);
		if(result == null && className.equals("java.lang.String")) //$NON-NLS-1$
			result = new StringValueFactory();
		return (IValueClassFactory)result;		
	}
	
	
	private static HashMap loadDisplayClassMap()
	{
		HashMap displayMap = new HashMap();

		IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint
			(UiPlugin.getID() + ".valueObjectExtension"); //$NON-NLS-1$

		if (extensionPoint != null)
		{
			try {
      
				IConfigurationElement[] extensionPoints = extensionPoint.getConfigurationElements();
				for(int i = 0; i < extensionPoints.length; i++)
				{
					if(mapVendorID != null)
					{
						String vendorID = extensionPoints[i].getAttribute("vendorID"); //$NON-NLS-1$
						if(!mapVendorID.equals(vendorID))
							continue;
					}
					String type = extensionPoints[i].getAttribute("type"); //$NON-NLS-1$
					IDisplayValueClass displayValueClass = (IDisplayValueClass)extensionPoints[i].createExecutableExtension("displayValueClass"); //$NON-NLS-1$
					displayMap.put(type, displayValueClass);						
				}
			}
			catch(Exception e)
			{
			}
		}	

		return displayMap;
	}

	private static HashMap loadValidatorClassMap()
	{
		HashMap validatorMap = new HashMap();

		IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint
			(UiPlugin.getID() + ".valueObjectValidatorExtension"); //$NON-NLS-1$
		
		if (extensionPoint != null)
		{
			try {
	  
				IConfigurationElement[] extensionPoints = extensionPoint.getConfigurationElements();
				for(int i = 0; i < extensionPoints.length; i++)
				{
					if(mapVendorID != null)
					{
						String vendorID = extensionPoints[i].getAttribute("vendorID"); //$NON-NLS-1$
						if(!mapVendorID.equals(vendorID))
							continue;
					}
					String type = extensionPoints[i].getAttribute("type"); //$NON-NLS-1$
					IValidateValueClass validateValueClass = (IValidateValueClass)extensionPoints[i].createExecutableExtension("validateValueClass"); //$NON-NLS-1$
					validatorMap.put(type, validateValueClass);						
				}
			}
			catch(Exception e)
			{
			}
		}		
		return validatorMap;
	}

	private static HashMap loadValueFactoryMap()
	{
		HashMap valueFactoryMap = new HashMap();

		IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint
			(UiPlugin.getID() + ".valueObjectExtension"); //$NON-NLS-1$
		
		if (extensionPoint != null)
		{
			try {
	  
				IConfigurationElement[] extensionPoints = extensionPoint.getConfigurationElements();
				for(int i = 0; i < extensionPoints.length; i++)
				{
					if(mapVendorID != null)
					{
						String vendorID = extensionPoints[i].getAttribute("vendorID"); //$NON-NLS-1$
						if(!mapVendorID.equals(vendorID))
							continue;
					}
					String type = extensionPoints[i].getAttribute("type"); //$NON-NLS-1$
					IValueClassFactory valueFactory = (IValueClassFactory)extensionPoints[i].createExecutableExtension("valueClassFactory"); //$NON-NLS-1$
					valueFactoryMap.put(type, valueFactory);						
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}		
		return valueFactoryMap;
	}
	
	
}
