/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ValueObject.java,v 1.6 2008/04/09 19:58:13 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.util;

import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDisplayValueClass;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/**
 * @author  Peter Sun
 * @author  Paul E. Slauenwhite
 * @version April 3, 2008
 * @since   January 27, 2005
 */
public class ValueObject {

	private Object theObject;
	protected IDisplayValueClass valueClass;
	private String description;
	private Object display;
	
	/**
	 */
	public ValueObject(Object theObject)
	{
		this.theObject = theObject;
		this.valueClass = ValueClassMap.getSWTValueDisplayClass(theObject);
		this.description = null;
	}
	
	/**
	 */
	public Object getObject()
	{
		return theObject;
	}
	
	public void setObject(Object newObject)
	{
		this.theObject = newObject;
		description = null;  //force to update
	}
	
	public Object getPropertyDisplay(Composite parent)
	{
		if ( display != null && display instanceof CellEditor )
		{
			Control control = ((CellEditor)display).getControl();
			if ( control != null && !control.isDisposed() )
				return display;
		}
		if ( valueClass != null )
		{
			display = valueClass.getPropertyDisplay(theObject, parent, true);
			return display;
		}
		return null;
	}
	
	/**
	 *@param parent
	 *@return Object
	 */
	public Object getEncryptedDisplay(Composite parent)
	{
		if ( display != null && display instanceof CellEditor )
		{
			Control control = ((CellEditor)display).getControl();
			if ( control != null && !control.isDisposed() )
				return display;
		}
		if ( valueClass != null )
		{
			display = ((EncryptedStringValueClass)valueClass).getPropertyDisplay(theObject, parent, true);
			return display;
		}
		return null;
	}
	public Object getDialogDisplay(Composite parent, boolean isEditable)
	{
		return null;
	}

	public Object updateObject()
	{
		if ( valueClass != null && display != null  )
		{
			theObject = valueClass.getUpdatedObject(theObject, display);
			description = valueClass.getPropertyDescription(theObject);
		}
		return theObject;
	}
	
	/**
	 */
	public String getDescription()
	{
		if ( description == null )
		{
			if ( valueClass != null )
				description = valueClass.getPropertyDescription(theObject);
			else if ( theObject != null )
				description = theObject.toString();
			else // theObject == null
				description = new String();
		}
		return description;
	}	


}
