/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EObjectResourceContentProvider.java,v 1.9 2008/11/04 14:20:24 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.dialog;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

/**
 * EObject resource content provider.
 * 
 * 
 * @author     Paul E. Slauenwhite
 * @author     Jerome Bozier
 * @version    October 31, 2008
 * @since      February 1, 2005
 * @deprecated As of TPTP V4.5.2, this class is deprecated. 
 */
public class EObjectResourceContentProvider implements ITreeContentProvider
{
    private String[] fileExtensions;
    public static final int FILTER_FOLDERS = 2;
	public static final int SHOW_ALL = 4;
	
	private int filter;
	private ArrayList list = new ArrayList();

	public EObjectResourceContentProvider(String[] fileExtensions)
	{
	    if(fileExtensions == null || fileExtensions.length == 0)
	        throw new IllegalArgumentException();
	    
        this.fileExtensions = fileExtensions;
	}

	public int getFilter()
	{
		return filter;
	}

	public void setFilter(int filter)
	{
		this.filter = filter;
	}
	
	public void dispose()
	{
		list.clear();
	}

	public void inputChanged(Viewer viewer, Object oldInput, Object newInput)
	{
	}

	public Object getParent(Object element)
	{
		if(element instanceof IResource)
			return ((IResource)element).getParent();
		
		if(element instanceof EObject)
		{
			EObject eObject = (EObject)element;			
			switch(filter)
			{
				case SHOW_ALL:
					IFile file = EMFUtil.getWorkspaceFile(eObject);
					if(file != null)
						return file.getParent();
					break;
			}
		}

		return null;
	}

	public boolean hasChildren(Object element)
	{
		return (getChildren(element).length > 0);
	}	

	public Object[] getElements(final Object inputElement)
	{
		if(inputElement instanceof IWorkspaceRoot)
		{			
			if(getFilter() == FILTER_FOLDERS)
			{			
				list.clear();		
				IProject[] projects = ((IWorkspaceRoot)inputElement).getProjects();					
				
				for(int idx=0; idx<projects.length; idx++)
				{
                    if (projects[idx].isAccessible()) {
                        Object[] children = getChildren(projects[idx]);
                        for (int i = 0; i < children.length; i++)
                            list.add(children[i]);
                    }											
				}
				
				return list.toArray();
			}
			else
			{
				return ((IWorkspaceRoot)inputElement).getProjects();				
			}				
		}
		
		return getChildren(inputElement);
	}

	/**
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
	 */
	public Object[] getChildren(Object parentElement)
	{
		if(parentElement instanceof IContainer)
		{
			if ((parentElement instanceof IProject) && (!((IProject)parentElement).isOpen())) {
				return new Object[0];
			}
			List children = new UniqueEList(); 
			IResource[] resources = null;
			try
			{
				resources = ((IContainer)parentElement).members();
			}
			catch (CoreException e)
			{
				UiPlugin.logError(e);
				return new Object[0];
			}
		 
			for(int i = 0, maxi = resources.length; i < maxi; i++)
			{
				if(resources[i].getType() != IResource.FILE)
				{
					if(filter == FILTER_FOLDERS)
					{
						Object[] tmpArray = getChildren(resources[i]);
						for(int k=0; k<tmpArray.length; k++)
						   children.add(tmpArray[k]);
					}
					else
						children.add(resources[i]);
				}
				else
				{
					IFile file = (IFile)resources[i];
					for(int j = 0; j < fileExtensions.length; j++)
					{
						String extension = file.getFileExtension();
						if(extension != null && extension.equals(fileExtensions[j]))
						{
							EObject[] eObjects = EMFUtil.load(new ResourceSetImpl(), (IFile)resources[i]);
							for (int idx=0; idx<eObjects.length; idx++)
							{
								Object eObject = eObjects[idx];
								children.add(eObject);						   
							}						    
							break;
						}
					}
				}
			}
		
			return children.toArray();
		}		
		else if(parentElement instanceof Resource)
			return ((Resource)parentElement).getContents().toArray();
	
		return new Object[0];
	}		
	/**
	 * @return Returns the fileExtensions.
	 */
	protected String[] getFileExtensions() {
		return fileExtensions;
	}
	/**
	 * @return Returns the list.
	 */
	protected ArrayList getList() {
		return list;
	}
}