/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EObjectResourceLabelProvider.java,v 1.7 2008/11/04 14:20:24 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.dialog;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

/**
 * EObjectResourceLabelProvider.java
 * 
 * 
 * @author     Paul E. Slauenwhite
 * @version    October 31, 2008
 * @since      February 1, 2005
 * @deprecated As of TPTP V4.5.2, this class is deprecated.
 */
public class EObjectResourceLabelProvider extends LabelProvider
{
	private Hashtable ovelayCache;
	private boolean useImages;
	private Image image;
    private Map imageMap;

	/**
	 * Constructor for PerspectiveLabelProvider
	 */
	public EObjectResourceLabelProvider(boolean useImages, Image image)
	{
		super();
		this.useImages = useImages;
		this.image = image;
		ovelayCache = new Hashtable();
        imageMap = new HashMap();
	}

	/**
	 * @see LabelProvider#getImage(Object)
	 */
	public Image getImage(Object element)
	{

        if((!useImages) || (element == null))
			return null;

		if (element instanceof IAdaptable)
		{
            if (imageMap==null || imageMap.isEmpty()) {
                imageMap = new HashMap();
            }
			IWorkbenchAdapter adapter =
				(IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);

			if(adapter != null) {
				ImageDescriptor myImageDesc = adapter.getImageDescriptor(element);
                Image myImage = (Image)imageMap.get(myImageDesc);
                if (myImage == null) {
                    myImage = myImageDesc.createImage();
                    imageMap.put(myImageDesc,myImage);
                }
                return myImage;
            }
		}

		if(this.image != null)
			return image;

        return null;            
	}

	/**
	 * @see LabelProvider#getText(Object)
	 */
	public String getText(Object element)
	{
		if(element == null)
			return ""; //$NON-NLS-1$

		String text = null;
	
		if(element instanceof EObject)
		{
			if(element instanceof CMNNamedElement){
				text = ((CMNNamedElement)(element)).getName();
			}
			else{
				text = EMFUtil.getWorkspaceFile(((EObject)(element))).getName();
			}
		}			
		else if(element instanceof IAdaptable)
		{
			IWorkbenchAdapter adapter =
				(IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);

			if(adapter != null)
				text = adapter.getLabel(element);
		}

		if(text == null)
			text = element.toString();
		
		return text;		
	}
	

	/**
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
	 */
	public void dispose()
	{
		if(ovelayCache != null)
		{
			for(Iterator i = ovelayCache.values().iterator(); i.hasNext();)
			{
				Image image = (Image)i.next();
				image.dispose();
			}
			ovelayCache.clear();
		}
        if (imageMap!=null) {
            for(Iterator i = imageMap.values().iterator(); i.hasNext();)
            {
                image = (Image)i.next();
                image.dispose();
            }
            imageMap.clear();
        }
	
		super.dispose();
	}
}