/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EObjectResourceSelectionDialog.java,v 1.8 2008/11/04 14:20:24 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.dialog;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.test.ui.internal.component.EObjectResourceSelectionViewer;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

/**
 * This class implements a dialog to select one or more resources with a certain file extension
 * in the workspace.
 * 
 * 
 * @author     Paul E. Slauenwhite
 * @author     Bianca Xue Jiang
 * @version    October 31, 2008
 * @since      February 1, 2005
 * @deprecated As of TPTP V4.5.2, this class is deprecated.
 */
public class EObjectResourceSelectionDialog extends Dialog implements SelectionListener, IDoubleClickListener
{
	private String[] fileExtensions;
	
	private String title;
	private EObjectResourceSelectionViewer viewer;
		
    public EObjectResourceSelectionDialog(Shell parentShell, String title, String[] theFileExtensions, Image fileImage) {
        this(parentShell, title, theFileExtensions, fileImage, SWT.NONE);
    }

    //- Bugzilla #125794
    public EObjectResourceSelectionDialog(Shell parentShell, String title, String[] theFileExtensions, Image fileImage, int style) {
        super(parentShell);
        this.title = title;
        this.fileExtensions = theFileExtensions;
        setShellStyle(parentShell.getStyle() | style);
    }
		
	protected Control createDialogArea(Composite parent)
	{
		Composite composite = (Composite)super.createDialogArea(parent);
		GridData gridData = GridDataUtil.createFill();
		gridData.heightHint = 300;
		gridData.widthHint = 250;
		composite.setLayoutData(gridData);
	
		createViewer(composite);
		
		return composite;
	}
	
	protected StructuredViewer createViewer(Composite parent)
	{
		viewer = new EObjectResourceSelectionViewer(parent,
				ResourcesPlugin.getWorkspace().getRoot(),
				fileExtensions,
				SWT.MULTI | SWT.FULL_SELECTION | SWT.BORDER);
		
		viewer.getViewer().addDoubleClickListener(this);
		return viewer.getViewer();
	}
	
	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		if (title != null)
			shell.setText(title);
	}
	
	public EObject[] getSelectedObjects()
	{
		return viewer.getSelectedObjects();
	}

	public IFile[] getSelectedFiles()
	{
		return viewer.getSelectedFiles();
	}

    /* (non-Javadoc)
     * @see org.eclipse.jface.viewers.IDoubleClickListener#doubleClick(org.eclipse.jface.viewers.DoubleClickEvent)
     */
    public void doubleClick(DoubleClickEvent event)
    {
        if(event.getViewer() == viewer.getViewer() )
        {
            viewer.setSelection();
            this.buttonPressed(IDialogConstants.OK_ID);
        }
        
    }	

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e)
	{
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e)
	{
		viewer.widgetSelected(e);
	}
	
}
