/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id$
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.editor.extension;

import org.eclipse.core.resources.IFile;

/**
 * This intreface should be implemented in order to be notified when the editor changes its write access.
 * @author marcelop
 * @since 1.0.2
 * @since 4.2 (public)
 */
public interface IWriteAccessChangeListener
{
    /**
     * This API is called each time an editor (editing the given file) changes ist write access. 
     * The write access is given by the boolean <code>isReadOnly</code>.
     * @param file the file edited
     * @param isReadOnly the new write access set to <code>true</code> if the editor becomes read only and <code>false</code> otherwise.
     */
	public void writeAccessChanged(IFile file, boolean isReadOnly);
}
