/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IHasEStructuralFeature.java,v 1.2 2005/02/25 22:17:54 hleung Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.editor.form.base;

import org.eclipse.emf.ecore.EStructuralFeature;

/**
 * The only purpose of this interface is to ensure that the form which implements
 * it has a structural feature (@see org.eclipse.emf.ecore.EStructuralFeature) to
 * reveal.
 * @author bcormier
 * @since 3.0.0
 */
public interface IHasEStructuralFeature {
    
    
	/**
	 * If the form which implements this interface has
	 * a structural feature (EStructuralFeature) that might need to
	 * be revealed, then this method must return it.
	 * @return the structural feature
	 */
	public EStructuralFeature getStructuralFeature();

}