/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IHyperlinkListener.java,v 1.2 2005/02/25 22:17:54 hleung Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.editor.form.base;

import org.eclipse.swt.widgets.Control;

/**
 * This interface represents the behavior a hyperlink listener should have.
 * @author marcelop, bcormier
 * @since 3.0.0
 */
public interface IHyperlinkListener {
	
	/**
	 * The control which represents a hyperlink is activated
	 * @param linkLabel the control
	 */
	public void linkActivated(Control linkLabel);
	
	/**
	 * The control which represents a hyperlink is entered
	 * @param linkLabel the control
	 */
	public void linkEntered(Control linkLabel);
	
	/**
	 * The control which represents a hyperlink is exited
	 * @param linkLabel the control
	 */
	public void linkExited(Control linkLabel);
}
