/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AbstractDetailPage.java,v 1.2 2005/06/13 14:26:34 jcanches Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.editor.form.util;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;

/**
 * Abstract default implementation of IDetailPage. This class may be used
 * as a base class for implementing IDetailPage. It provides conveniency methods
 * and stores the "context" property. The "context" property should be set by
 * the subclass, typically in the
 * {@link org.eclipse.hyades.test.ui.editor.form.util.IDetailPage#createControl(Composite, FormWidgetFactory, IDetailPageContext)}
 * method.
 * @author jcanches
 */
public abstract class AbstractDetailPage implements VerifyKeyListener, IDetailPage
	{
		protected IDetailPageContext context;

		/**
		 * This method may be overriden, and its implementation should include
		 * a call to super.dispose().
		 */
		public void dispose()
		{
			context = null;
		}

		/**
		 * Returns the form that contains the details page. This method
		 * is not meant to be overriden by subclassers.
		 * @return
		 */
		protected EditorForm getEditorForm()
		{
			return context.getEditorForm();
		}
		
		/**
		 * This method should be overriden if the details page provides a non-empty
		 * selection.
		 */
		public IStructuredSelection getStructuredSelection()
		{
			if(getInput() == null)
				return StructuredSelection.EMPTY;
			return new StructuredSelection(getInput());
		}

		/**
		 * This method should be overriden if the details page provides a non-empty
		 * selection.
		 */
		public void selectReveal(ISelection selection)
		{
			// NOP
		}
		
		/**
		 * Returns whether the details page is in a read-only context. This method
		 * is not meant to be overriden by subclassers.
		 * @return
		 */
		protected boolean isReadOnly()
		{
			return context.isReadOnly();
		}
		
		/**
		 * Default implementation that forwards the event to the page's parent.
		 * @see org.eclipse.swt.custom.VerifyKeyListener#verifyKey(org.eclipse.swt.events.VerifyEvent)
		 */
		public void verifyKey(VerifyEvent event)
		{
			context.verifyKey(event);
		}
		
	}