/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EObjectTableContentProvider.java,v 1.4 2010/02/16 20:21:34 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.editor.form.util;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

/**
 * <p>An <code>EObject</code> table content provider.</p>
 * 
 * 
 * @author  Marcelo Paternostro
 * @author  Bianca Jiang Xue
 * @author  Paul Slauenwhite
 * @version February 16, 2010
 * @since   February 1, 2005
 * @see	org.eclipse.hyades.test.ui.editor.form.util.EObjectContainerContentProvider
 */
public class EObjectTableContentProvider extends EObjectContainerContentProvider {

	/**
	 * Constructor to created an <code>EObject</code> container content provider.
	 * 
	 * @param editorForm The editor of the <code>EObject</code> container content provider.	 
     * @param eStructuralFeature The {@link EStructuralFeature} of the <code>EObject</code> table content provider.
	 */
	public EObjectTableContentProvider(EditorForm editorForm, EStructuralFeature eStructuralFeature) {
		super(editorForm, eStructuralFeature);
	}
	
	public TableViewer getTableViewer()
	{
	    Viewer viewer = super.getViewer();
	    if(viewer instanceof TableViewer)
	        return (TableViewer)viewer;
	    
	    return null;
	}
	
	protected void updateViewer(Notification msg)
	{
		if(getViewer() == null)
			return;

		if(!(getViewer() instanceof StructuredViewer))
		{
			getViewer().refresh();
			return;
		}

		if(msg.getNotifier() != getContainer())
		{
			switch(msg.getEventType())
			{
				case Notification.SET:
				case Notification.UNSET:
					attributeChanged(msg);
					return;
			}
		}

		if(!(getViewer() instanceof TableViewer))
		{
			getViewer().refresh();
			return;
		}
			
		if(shouldUpdateViewer(msg))
		{	
		    updateViewerWithNotification(msg);
		}
	}
	
	protected void updateViewerWithNotification(Notification msg)
	{
	    switch(msg.getEventType())
		{
			case Notification.ADD:
				((TableViewer)getViewer()).add(msg.getNewValue());
				getViewer().setSelection(new StructuredSelection(msg.getNewValue()), true);
				break;

			case Notification.ADD_MANY:
				Object[] addedObjects = ((Collection)msg.getNewValue()).toArray();
				((TableViewer)getViewer()).add(addedObjects);
				getViewer().setSelection(new StructuredSelection(addedObjects), true);
				break;
					
			case Notification.REMOVE:
				((TableViewer)getViewer()).remove(msg.getOldValue());
				Object value = ((EObject)msg.getNotifier()).eGet((EStructuralFeature)msg.getFeature());
				if(value instanceof List)
				{
					List values = (List)value;
					if(values.isEmpty())
					{
						getViewer().getControl().setFocus();
					}
					else
					{
						int position = msg.getPosition();
						position = (position<values.size())?position:(values.size()-1);
						getViewer().setSelection(new StructuredSelection(values.get(position)), true);
					}
				}
				else
				{
					getViewer().getControl().setFocus();
				}
				break;

			case Notification.REMOVE_MANY:
				((TableViewer)getViewer()).remove(((Collection)msg.getOldValue()).toArray());
				getViewer().getControl().setFocus();
				break;

			case Notification.MOVE:
				getViewer().refresh();
				break;
		}
	}
}
