/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EditorSection.java,v 1.4 2005/03/16 22:10:07 bjiang Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.editor.form.util;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.ui.part.ISetSelectionTarget;

import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.ui.editor.IHyadesEditorPart;
import org.eclipse.hyades.ui.util.IDisposable;

/**
 * @deprecated 
 * <p>The implementation of this class is not based on Eclipse Forms(a.k.a. "flat" look) 
 * framework that was made available publically in Eclipse 3.0. If you would like your editor(s) to be 
 * built with the Eclipse Forms technology, this is NOT the class to extend. To know more about 
 * Eclipse Forms: <br>
 * <a href="http://dev.eclipse.org/viewcvs/index.cgi/%7Echeckout%7E/pde-ui-home/working/EclipseForms/EclipseForms.html">Eclipse Forms Programming Guide</a>
 * </p>
 * 
 * @author marcelop
 * @since 3.0.0
 */
public abstract class EditorSection 
extends FormSection implements IDisposable, VerifyKeyListener, ISetSelectionTarget
{
	private EditorForm editorForm;
	private FormWidgetFactory formWidgetFactory;
	
	/**
	 * Constructor for EMFEditorSection
	 * @param editorForm
	 */
	protected EditorSection(EditorForm editorForm)
	{
		this.editorForm = editorForm;
	}
	
	/**
	 * Disposes this section.
	 */
	public void dispose()
	{
		editorForm = null;
		formWidgetFactory = null;
		
		super.dispose();
	}
	
	protected FormWidgetFactory getFormWidgetFactory()
	{
		return formWidgetFactory;		
	}

	protected void setFormWidgetFactory(FormWidgetFactory formWidgetFactory)
	{
		this.formWidgetFactory = formWidgetFactory;		
	}

	/**
	 * Returns this section's editor form.
	 * @return EditorForm
	 */
	public EditorForm getEditorForm()
	{
		return editorForm;
	}
	
	/**
	 * Utility method to retrieve the Hyades editor part.
	 * @return IHyadesEditorPart
	 */
	protected IHyadesEditorPart getHyadesEditorPart()
	{
		return getEditorForm().getBaseEditorExtension().getHyadesEditorPart();
	}
	
	/**
	 * Utility method to retrieve the clipboard.
	 * @return Clipboard
	 */
	protected Clipboard getClipboard()
	{
		return getEditorForm().getBaseEditorExtension().getClipboard();
	}
	
	/**
	 * Gives the element permissions.
	 * @return true if the element is read-only. Otherwise, false.
	 */
	public boolean isReadOnly()
	{
		return getHyadesEditorPart().isReadOnly();
	}

	/**
	 * Tells if the content of the element has changed.
	 * @return true if the content of the element has changed. Otherwise, false.
	 */
	public boolean isDirty()
	{
		return getHyadesEditorPart().isDirty();
	}

	/**
	 * Initializes the section with the input.
	 * @param input the input.
	 */
	public void initialize(Object input)
	{
		setInput(input);
	}

	/**
	 * Place holder that customers can invoke to trigger the section's data to
	 * be loaded.
	 * @param object  This section input.
	 */
	abstract public void setInput(Object object);
	
	/**
	 * Returns the section's input.
	 * @return Object
	 */
	abstract public Object getInput();

	/**
	 * Returns this section's selection.
	 * @return IStructuredSelection
	 */
	abstract public IStructuredSelection getStructuredSelection();

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection#reflow()
	 */
	protected void reflow()
	{
		super.reflow();
		editorForm.updateScrollBars();
	}

	/**
	 * @see org.eclipse.swt.custom.VerifyKeyListener#verifyKey(org.eclipse.swt.events.VerifyEvent)
	 */
	public void verifyKey(VerifyEvent event)
	{
		event.doit = !getHyadesEditorPart().isReadOnly();
	}
}
