/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDetailPage.java,v 1.1 2005/03/16 17:23:06 jcanches Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.editor.form.util;

import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/**
 * A pane that displays properties (and optionnaly, allows editing of) for an
 * input element. This pane appears in details sections of TPTP editors.
 * @author jcanches
 * @see org.eclipse.hyades.test.ui.editor.form.util.IDetailPageFactory
 * @since 4.0
 */
public interface IDetailPage extends IDisposable {

	/**
	 * Sets the input of the details page and updates its content to represent
	 * the input object properties.
	 * @param object
	 */
	void setInput(Object object);
	
	/**
	 * Returns the current details page input.
	 * @return The current details page input.
	 */
	public Object getInput();
	
	/**
	 * Creates the control of the details page.
	 * @param parent The parent control.
	 * @param factory A Widget Factory that may be used for creating advanced widgets within
	 * the details page control.
	 * @param context The context of the details page.
	 * @return The control of the details page.
	 */
	Control createControl(Composite parent, FormWidgetFactory factory, IDetailPageContext context);
	
	/**
	 * Selects and reveal a selection within the details page. Does nothing if
	 * the selection is not applicable.
	 * @param selection
	 */
	void selectReveal(ISelection selection);
	
	/**
	 * Returns the current selection within the details page.
	 * @return The current selection. If not applicable, or if the selection is empty,
	 * returns StructuredSelection.EMPTY.
	 */
	IStructuredSelection getStructuredSelection();
	
}
