/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDetailPageContext.java,v 1.1 2005/03/16 17:23:06 jcanches Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.editor.form.util;

import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;

/**
 * Describes the context of a Detail Page. This interface is used by
 * implementations of IDetailPage to get information about the context
 * (e.g. is it in read-only form).<br>
 * This interface is not meant to be implemented by clients.
 * @author jcanches
 * @since 4.0
 */
public interface IDetailPageContext extends VerifyKeyListener {

	/**
	 * Returns the editor form that contains the details page.
	 * @return
	 */
	EditorForm getEditorForm();
	
	/**
	 * Returns whether the details page is modifiable.
	 * @return <code>true</code> if the details page is not modifiable, <code>false</code>
	 * otherwise.
	 */
	boolean isReadOnly();
	
	/**
	 * Forwards a verifyEvent received by the details page to its parent.
	 */
	void verifyKey(VerifyEvent event);
	
}
