/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDetailPageFactory.java,v 1.3 2006/01/30 09:19:56 jgout Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.editor.form.util;

/**
 * Create DetailPages for specific execution event or result types. This interface is used
 * by the extension point org.eclipse.hyades.test.ui.executionHistoryExtension.
 * @deprecated Attribute <i>detailPageFactory</i> was deprecated and replaced by <i>eventDetailsProvider</i>
 * in extension point org.eclipse.hyades.test.ui.executionHistoryExtension 
 * @author jcanches
 * @since 4.0
 */
public interface IDetailPageFactory {

	/**
	 * Creates and return a DetailPage for events of type eventType.
	 * @param eventType The type of event that the returned DetailPage describes.
	 * @return A DetailPage. The returned value's lifecyle is managed by the caller.
	 */
	IDetailPage createExecutionEventDetailPage(String eventType);
	
	/**
	 * Creates and return a DetailPage for results of type resultType.
	 * @param resultType The type of execution result that the returned DetailPage describes.
	 * @return A DetailPage. The returned value's lifecyle is managed by the caller.
	 */
	IDetailPage createExecutionResultDetailPage(String resultType);
	
}
