/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NamedElementSection.java,v 1.10 2008/03/20 19:49:55 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.editor.form.util;

import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

/**
 * @deprecated 
 * <p>The implementation of this class is not based on Eclipse Forms(a.k.a. "flat" look) 
 * framework that was made available publically in Eclipse 3.0. If you would like your editor(s) to be 
 * built with the Eclipse Forms technology, this is NOT the class to extend. To know more about 
 * Eclipse Forms: <br>
 * <a href="http://dev.eclipse.org/viewcvs/index.cgi/%7Echeckout%7E/pde-ui-home/working/EclipseForms/EclipseForms.html">Eclipse Forms Programming Guide</a>
 * </p>
 * 
 * @author marcelop
 * @author Jerome Bozier
 * @version March 14, 2008
 * @since 3.0.0
 */
public class NamedElementSection 
extends EditorSection implements ModifyListener
{
	private StyledText nameText;
	private StyledText descriptionText;
	
	private CMNNamedElement namedElement;

	/**
	 * Constructor for NamedElementSection
	 * @param editorForm 
	 */
	public NamedElementSection(EditorForm editorForm)
	{
		super(editorForm);
		setCollapsable(true);
	}
	
	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#dispose()
	 */
	public void dispose()
	{
		namedElement = null;
		super.dispose();
	}

	protected CMNNamedElement getNamedElement()
	{
		return namedElement;
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#createClient(org.eclipse.swt.widgets.Composite, org.eclipse.update.ui.forms.internal.FormWidgetFactory)
	 */
	public Composite createClient(Composite parent, FormWidgetFactory formWidgetFactory)
	{
		WidgetFactory widgetFactory = getEditorForm().getWidgetFactory();
		Composite composite = widgetFactory.createComposite(parent);
		composite.setLayout(new GridLayout());
				
		widgetFactory.createLabel(composite, UiPluginResourceBundle.LBL_NAME); 
		nameText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		nameText.setLayoutData(GridDataUtil.createHorizontalFill());
		nameText.setEditable(false);
		nameText.getAccessible().addAccessibleListener(new AccessibleAdapter() {
			public void getName(AccessibleEvent e) {
				e.result = UiPluginResourceBundle.W_NAME; 
			}
		});
				
		addCenterControls(composite, widgetFactory);
				
		widgetFactory.createLabel(composite, UiPluginResourceBundle.LBL_DESC); 
		descriptionText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.MULTI | SWT.WRAP | SWT.V_SCROLL);
		GridData gridData = GridDataUtil.createHorizontalFill();
		gridData.heightHint = 4*descriptionText.getLineHeight();
		descriptionText.setLayoutData(gridData);
		descriptionText.setEditable(false);
		descriptionText.getAccessible().addAccessibleListener(new AccessibleAdapter() {
			public void getName(AccessibleEvent e) {
				e.result = UiPluginResourceBundle.W_DESCRIPTION; 
			}
		});
								
		addSouthControls(composite, widgetFactory);

		widgetFactory.paintBordersFor(composite);
		return composite;
	}
	
	/**
	 * The client should override this method to add controls between the name and the description 
	 * sections of this named element section.
	 * @param parent The parent composite.
	 * @param formWidgetFactory The widget factory.
	 * @deprecated Use addCenterControls(Composite parent, WidgetFactory formWidgetFactory) instead.
	 */
	protected void addCenterControls(Composite parent, FormWidgetFactory formWidgetFactory)
	{
	}

	/**
	 * The client should override this method to add controls after the description 
	 * section of this named element section.
	 * @param parent The parent composite.
	 * @param formWidgetFactory The widget factory.
	 * @deprecated Use addSouthControls(Composite parent, WidgetFactory formWidgetFactory) instead.
	 */
	protected void addSouthControls(Composite parent, FormWidgetFactory formWidgetFactory)
	{
	}
	
	/**
	 * The client should override this method to add controls between the name and the description 
	 * sections of this named element section.
	 * @param parent The parent composite.
	 * @param widgetFactory The widget factory.
	 */	
	protected void addCenterControls(Composite parent, WidgetFactory widgetFactory)
	{
	    addCenterControls(parent, (FormWidgetFactory)widgetFactory);
	}
	
	/**
	 * The client should override this method to add controls after the description 
	 * section of this named element section.
	 * @param parent The parent composite.
	 * @param widgetFactory The widget factory.
	 */	
	protected void addSouthControls(Composite parent, WidgetFactory widgetFactory)
	{
	    addSouthControls(parent, (FormWidgetFactory)widgetFactory);
	}
	
	/**
	 * Place holder that customers can invoke to trigger the section's data to
	 * be loaded.
	 * By default, this method only handles the name and description fields of the
	 * named element section. In addition, the customer might override this section
	 * to handle south and center controls.
	 * @param object  This section input.
	 */
	public void setInput(Object object)
	{
		namedElement = null;

		nameText.removeVerifyKeyListener(this);
		nameText.removeModifyListener(this);
		descriptionText.removeVerifyKeyListener(this);
		descriptionText.removeModifyListener(this);

		if(object instanceof IStructuredSelection)
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)object;
			if(structuredSelection.size() == 1)
				object = structuredSelection.getFirstElement();
		}

		if(object instanceof CMNNamedElement)
		{
			namedElement = (CMNNamedElement)object;
			
			String value = getNamedElement().getName();
			if(value != null)
				nameText.setText(value);
			else
				nameText.setText(""); //$NON-NLS-1$
			
			value = getNamedElement().getDescription();
			if(value != null)
				descriptionText.setText(value);
			else
				descriptionText.setText(""); //$NON-NLS-1$	

			nameText.setEditable(true);
			descriptionText.setEditable(true);			
		}
		else
		{
			nameText.setText(""); //$NON-NLS-1$
			descriptionText.setText(""); //$NON-NLS-1$

			nameText.setEditable(false);
			descriptionText.setEditable(false);			
		}
		
		nameText.addVerifyKeyListener(this);
		nameText.addModifyListener(this);
		descriptionText.addVerifyKeyListener(this);
		descriptionText.addModifyListener(this);					
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseEditorSection#getInput()
	 */
	public Object getInput()
	{
		return namedElement;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseEditorSection#getStructuredSelection()
	 */
	public IStructuredSelection getStructuredSelection()
	{
		if(namedElement == null)
			return StructuredSelection.EMPTY;
		return new StructuredSelection(namedElement);
	}

	/**
	 * @see org.eclipse.ui.part.ISetSelectionTarget#selectReveal(org.eclipse.jface.viewers.ISelection)
	 */
	public void selectReveal(ISelection selection)
	{

	}

	/**
	 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
	 */
	public void modifyText(ModifyEvent e)
	{
		if((e.widget == nameText))
		{
			getNamedElement().setName(nameText.getText());
			getEditorForm().updateTitle();
			getEditorForm().getBaseEditorExtension().markDirty();
		}
		else if(e.widget == descriptionText)
		{
			getNamedElement().setDescription(descriptionText.getText());
			getEditorForm().getBaseEditorExtension().markDirty();
		}
	}
	
	protected StyledText getNameTextField()
	{
		return this.nameText;
	}
	
	protected StyledText getDescriptionTextField()
	{
		return this.descriptionText;
	}
}