/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: WidgetFactory.java,v 1.14 2010/03/31 20:56:00 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.editor.form.util;

import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ST;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

/**
 * <p>This class allows the client to create some widgets. In general, this class will log the
 * error is failed to create the widgets and return <code>null</code>.</p>
 * 
 * 
 * @author     Marcelo Paternostro
 * @author     B Cormier
 * @author     Paul E. Slauenwhite
 * @version    March 31, 2010
 * @since      February 1, 2005
 * @deprecated The implementation of this class is not based on Eclipse Forms(a.k.a. "flat" look) 
 * framework that was made available publicly in Eclipse 3.0. If you would like your editor(s) to be 
 * built with the Eclipse Forms technology, this is NOT the class to extend. To know more about 
 * Eclipse Forms: <a href="http://dev.eclipse.org/viewcvs/index.cgi/%7Echeckout%7E/pde-ui-home/working/EclipseForms/EclipseForms.html">Eclipse Forms Programming Guide</a>
 */
public class WidgetFactory extends FormWidgetFactory implements IDisposable{
	
	/**
	 * Constructor for WidgetFactory
	 * 
	 */
	public WidgetFactory()
	{
		this(Display.getCurrent());
	}

	/**
	 * Constructor for WidgetFactory
	 * @param display
	 */
	public WidgetFactory(Display display)
	{
		super(display);
	}
	
	/**
	 * Creates a styled text.
	 * @param parent
	 * @param style
	 * @return StyledText
	 */
	public StyledText createStyledText(Composite parent, int style)
	{
		try
		{
			StyledText styledText = new StyledText(parent, style);
	
			styledText.setBackground(getBackgroundColor());
			styledText.setForeground(getForegroundColor());
			addEditPopupMenu(styledText);			
			return styledText;
		}
		catch(Throwable t)
		{
			UiPlugin.logError(t);
		}
		return null;
	}

	/**
	 * Convenience method to also create a valid accessible listener when creating the StyledText
	 * @param parent
	 * @param style
	 * @return StyledText
	 */	
	public StyledText createStyledText(Composite parent, int style, final String accessibleName)
	{ //added for bugzilla_99269
		StyledText text = createStyledText(parent, style);
		text.getAccessible().addAccessibleListener(
				new AccessibleAdapter() {
					public void getName(AccessibleEvent e) {
						e.result = accessibleName;
					}
				}
				);
		return text;
	}
	/**
	 * Adds a Copy/Cut/Paste popup menu to the specified StyledText. The activation of this
	 * menu is platform-dependant (right-click on Windows platforms for instance).
	 * This menu is automatically created if the StyledText has been created thanks to
	 * createStyledText.
	 * This method might be overriden.
	 * @param text The StyledText.
	 * @return the created edit menu.
	 */
	public Menu addEditPopupMenu(StyledText text) {
		try
		{
			Menu menu = new Menu(text);
			text.setMenu(menu);
            
			// Cut
			MenuItem cutItem = new MenuItem(menu, SWT.NONE);
			cutItem.setText(UiPluginResourceBundle.command_Cut); 
			cutItem.setData(text);
			cutItem.setEnabled(text.isEnabled() && text.getEditable());
			cutItem.addSelectionListener(new SelectionListener() {
	            public void widgetSelected(SelectionEvent e) {
	                if (e.widget!=null && e.widget instanceof MenuItem) {
	                    MenuItem menuItem = (MenuItem)e.widget;
	                    Object obj = menuItem.getData();
	                    if (obj!=null && obj instanceof StyledText) {
	                        ((StyledText)obj).cut();
	                    }
	                }
	            }
	
	            public void widgetDefaultSelected(SelectionEvent e) {
	                // Nothing to do ...
	            }
	        });
			
			// Copy
			MenuItem copyItem = new MenuItem(menu, SWT.NONE);
			copyItem.setText(UiPluginResourceBundle.command_Copy); 
			copyItem.setData(text);
            copyItem.addSelectionListener(new SelectionListener() {
	            public void widgetSelected(SelectionEvent e) {
	                if (e.widget!=null && e.widget instanceof MenuItem) {
	                    MenuItem menuItem = (MenuItem)e.widget;
	                    Object obj = menuItem.getData();
	                    if (obj!=null && obj instanceof StyledText) {
	                        ((StyledText)obj).copy();
	                    }
	                }
	            }
	
	            public void widgetDefaultSelected(SelectionEvent e) {
	                // Nothing to do ...
	            }
	        });			
			// Paste
			MenuItem pasteItem = new MenuItem(menu, SWT.NONE);
			pasteItem.setText(UiPluginResourceBundle.command_Paste); 
			pasteItem.setData(text);
			pasteItem.setEnabled(text.isEnabled() && text.getEditable());
			pasteItem.addSelectionListener(new SelectionListener() {
	            public void widgetSelected(SelectionEvent e) {
	                if (e.widget!=null && e.widget instanceof MenuItem) {
	                    MenuItem menuItem = (MenuItem)e.widget;
	                    Object obj = menuItem.getData();
	                    if (obj!=null && obj instanceof StyledText) {
	                        ((StyledText)obj).paste();
	                    }
	                }
	            }
	
	            public void widgetDefaultSelected(SelectionEvent e) {
	                // Nothing to do ...
	            }
	        });
			new MenuItem(menu, SWT.SEPARATOR);
			
			// Delete
			MenuItem deleteItem = new MenuItem(menu, SWT.NONE);
			deleteItem.setText(UiPluginResourceBundle.command_Delete); 
			deleteItem.setData(text);
			deleteItem.setEnabled(text.isEnabled() && text.getEditable());
			deleteItem.addSelectionListener(new SelectionListener() {
	            public void widgetSelected(SelectionEvent e) {
	                if (e.widget!=null && e.widget instanceof MenuItem) {
	                    MenuItem menuItem = (MenuItem)e.widget;
	                    Object obj = menuItem.getData();
	                    if (obj!=null && obj instanceof StyledText) {
	                    	StyledText styledText = (StyledText)obj;
	                    	styledText.invokeAction(ST.DELETE_NEXT);
	                    }
	                }
	            }
	
	            public void widgetDefaultSelected(SelectionEvent e) {
	                // Nothing to do ...
	            }
	        });
					
					
					// Select All
			MenuItem selectAllItem = new MenuItem(menu, SWT.NONE);
			selectAllItem.setText(UiPluginResourceBundle.command_SelectAll); 
			selectAllItem.setData(text);
			selectAllItem.setEnabled(text.isEnabled() && text.getEditable());
			selectAllItem.addSelectionListener(new SelectionListener() {
	            public void widgetSelected(SelectionEvent e) {
	                if (e.widget!=null && e.widget instanceof MenuItem) {
	                    MenuItem menuItem = (MenuItem)e.widget;
	                    Object obj = menuItem.getData();
	                    if (obj!=null && obj instanceof StyledText) {
	                    	StyledText styledText = (StyledText)obj;
	                    	styledText.setSelection(0,styledText.getText().length());
	                    }
	                }
	            }
	
	            public void widgetDefaultSelected(SelectionEvent e) {
	                // Nothing to do ...
	            }
	        });
            
            menu.addListener (SWT.Show, new Listener () {
                public void handleEvent(Event event) {
                    MenuItem[] menuItems = ((Menu) event.widget).getItems();
                    for (int i = 0; i < menuItems.length; i++) {
                        MenuItem item = (MenuItem)menuItems[i];
                        Object obj = item.getData();
                        if (obj!=null && obj instanceof StyledText) {
                            if (item.getText().equals(UiPluginResourceBundle.command_SelectAll)) { 
                                item.setEnabled(((StyledText)obj).isEnabled() && ((StyledText)obj).getEditable() && ((StyledText)obj).getCharCount()>0);
                            } else if (item.getText().equals(UiPluginResourceBundle.command_Paste)) { 
                                Clipboard clip = new Clipboard(Display.getCurrent());
                                if (clip.getContents(TextTransfer.getInstance())!=null && clip.getContents(TextTransfer.getInstance()).toString().length()>0) {
                                    item.setEnabled(true);
                                } else {
                                    item.setEnabled(false);
                                }
                            } else {
                                item.setEnabled(((StyledText)obj).isEnabled() && ((StyledText)obj).getEditable() && ((StyledText)obj).getSelectionCount()>0);
                            }
                        }
                    } 
                }
            });
            
			return menu;
		}
		catch(Throwable t)
		{
			UiPlugin.logError(t);
		}
		return null;
	}
	
	/**
	 * Creates a ccombo or return <code>null</code> if fails.
	 * @param parent
	 * @param style
	 * @return CCombo
	 */
	public CCombo createCCombo(Composite parent, int style)
	{
		try
		{
			CCombo combo = new CCombo(parent, style);
	
			combo.setBackground(getBackgroundColor());
			combo.setForeground(getForegroundColor());
			return combo;
		}
		catch(Throwable t)
		{
			UiPlugin.logError(t);
		}
		return null;
	}
}
