/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CollapseTreeAction.java,v 1.5 2010/04/07 19:37:41 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.forms.actions;

import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;

/**
 * <p>CollapseTreeAction.java</p>
 * 
 * 
 * @author  Bianca Xue Jiang
 * @author  Paul Slauenwhite
 * @version April 7, 2010
 * @since   September 21, 2005
 */
public class CollapseTreeAction extends TreeSelectionAction {
	
	private ExpandTreeAction expandAction;
	
	public CollapseTreeAction(String text, TreeViewer treeViewer) {
		super(text, treeViewer);
		setToolTipText(UiPluginResourceBundle.TestLogViewer_CollapseSelection); 
		setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("e", TestUIImages.IMG_COLLAPSE_ALL)); //$NON-NLS-1$
		setDisabledImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("d", TestUIImages.IMG_COLLAPSE_ALL)); //$NON-NLS-1$
	}

	protected boolean updateSelection(IStructuredSelection selection) {
		if(super.updateSelection(selection) == false)
			return false;
		
		if(!selection.isEmpty())
		{
			Object element = selection.getFirstElement();
			if(getViewer().getExpandedState(element) == true)
				return true;
		}
		
		return false;
	}
	
	public void treeCollapsed(TreeExpansionEvent event) {
		if(event.getElement() == ((IStructuredSelection)getViewer().getSelection()).getFirstElement())
			setEnabled(false);
	}
	
	public void treeExpanded(TreeExpansionEvent event) {
		if(event.getElement() == ((IStructuredSelection)getViewer().getSelection()).getFirstElement())
			setEnabled(true);
	}
	
	public void setExpandAction(ExpandTreeAction expandAction) {
		this.expandAction = expandAction;
	}
	
	public void run() {
		
		IStructuredSelection structuredSelection = ((IStructuredSelection)(getViewer().getSelection()));
		
		if((structuredSelection != null) && (!structuredSelection.isEmpty())){
			
			//Collapse the selected element:
			//Note: When parent nodes are collapsed in a virtual tree, the child nodes are removed from tree and need to be recreated.
			getViewer().collapseToLevel(structuredSelection.getFirstElement(), TreeViewer.ALL_LEVELS);
			
			//Disable this action:
			setEnabled(false);
			
			//Enable the expand tree action (if it exists):
			if(expandAction != null){
				expandAction.setEnabled(true);
			}
		}
	}
}
