/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExpandTreeAction.java,v 1.5 2010/04/07 19:37:41 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.forms.actions;

import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;

/**
 * <p>ExpandTreeAction.java</p>
 * 
 * 
 * @author  Bianca Xue Jiang
 * @author  Paul Slauenwhite
 * @version April 7, 2010
 * @since   September 21, 2005
 */
public class ExpandTreeAction extends TreeSelectionAction {

	private CollapseTreeAction collapseAction;
	
	public ExpandTreeAction(String text, TreeViewer treeViewer) {
		super(text, treeViewer);
		setToolTipText(UiPluginResourceBundle.TestLogViewer_ExpandSelection); 
		setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("e", TestUIImages.IMG_EXPAND_ALL)); //$NON-NLS-1$
		setDisabledImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("d", TestUIImages.IMG_EXPAND_ALL)); //$NON-NLS-1$
	}

	protected boolean updateSelection(IStructuredSelection selection) {
		if(super.updateSelection(selection) == false)
			return false;
		
		if(!selection.isEmpty())
		{
			Object element = selection.getFirstElement();
			boolean hasChildren = ((ITreeContentProvider)getViewer().getContentProvider()).hasChildren(element);
			if(hasChildren && !getViewer().getExpandedState(element))
				return true;
		}
		
		return false;
	}

	public void treeCollapsed(TreeExpansionEvent event) {
		if(event.getElement() == ((IStructuredSelection)getViewer().getSelection()).getFirstElement())
			setEnabled(true);
	}
	
	public void treeExpanded(TreeExpansionEvent event) {
		if(event.getElement() == ((IStructuredSelection)getViewer().getSelection()).getFirstElement())
			setEnabled(false);
	}
	
	public void setCollapseAction(CollapseTreeAction collapseAction) {
		this.collapseAction = collapseAction;
	}
	
	public void run() {
		
		IStructuredSelection structuredSelection = ((IStructuredSelection)(getViewer().getSelection()));
	
		if((structuredSelection != null) && (!structuredSelection.isEmpty())){
			
			//Expand the selected element:
			getViewer().expandToLevel(structuredSelection.getFirstElement(), TreeViewer.ALL_LEVELS);
			
			//Disable this action:
			setEnabled(false);
			
			//Enable the collapse tree action (if it exists):
			if(collapseAction != null){
				collapseAction.setEnabled(true);
			}
		}
	}
}
