/*******************************************************************************
 * Copyright (c) 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestLogSearchAction.java,v 1.1 2009/02/23 14:52:14 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.forms.actions;

import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.search.TestLogSearchPage;
import org.eclipse.jface.action.Action;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.PlatformUI;

/**
 * <p>An action to open the Search dialog (<i>Search &gt;&gt; Search... Ctrl+H</i>) 
 * with the Test Log Search page brought to the top.</p>
 * 
 * <p>Assumption: This action is invoked from a workbench window.</p>
 * 
 * 
 * @author  	Paul E. Slauenwhite
 * @version 	February 23, 2009
 * @since   	February 23, 2009
 * @provisional As of TPTP V4.5.3, this is stable provisional API (see http://www.eclipse.org/tptp/home/documents/process/development/api_contract.html).
 */
public class TestLogSearchAction extends Action {

	public TestLogSearchAction() {
		
		super();

		setText(UiPluginResourceBundle.TestLogViewer_TestLogSearchActionText);
		
		setToolTipText(UiPluginResourceBundle.TestLogViewer_TestLogSearchActionToolTip); 
		
		//Assumption: This action is never disabled.
		setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("e", TestUIImages.IMG_LOG_SEARCH)); //$NON-NLS-1$
	}
		
	public void run() {
		NewSearchUI.openSearchDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), TestLogSearchPage.TEST_LOG_SEARCH_PAGE_ID);
	}
}
