/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TreeSelectionAction.java,v 1.1 2005/09/21 19:22:12 bjiang Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.forms.actions;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.actions.SelectionListenerAction;

/**
 * This class is 
 * 
 * @author bjiang
 * @since  4.1
 */
public class TreeSelectionAction extends SelectionListenerAction implements ITreeViewerListener{

	private TreeViewer viewer;
	
	public TreeSelectionAction(String text, TreeViewer treeViewer) {
		super(text);
		setViewer(treeViewer);
	}
	
	protected boolean updateSelection(IStructuredSelection selection) {
		if(super.updateSelection(selection) == false || selection == null || selection.isEmpty())
			return false;
		return true;
	}
	
	public void setViewer(TreeViewer viewer) {
		if(viewer == null)
			return;
		
		if(this.viewer != null)
			this.viewer.removeSelectionChangedListener(this);
		this.viewer = viewer;
		this.viewer.addSelectionChangedListener(this);
		this.viewer.addTreeListener(this);
		setEnabled(updateSelection((IStructuredSelection)viewer.getSelection()));
	}
	
	public TreeViewer getViewer() {
		return viewer;
	}
	
	/**
	 * Implementation of this class does nothing, subclass should override this method to customize its behavior.
	 */
	public void treeCollapsed(TreeExpansionEvent event) {
	}
	
	/**
	 * Implementation of this class does nothing, subclass should override this method to customize its behavior.
	 */
	public void treeExpanded(TreeExpansionEvent event) {
	}
}
