/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: VerdictPreviousAction.java,v 1.6 2008/07/11 13:44:46 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.forms.actions;

import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.forms.util.ITestLogVerdictTraversal;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;

/**
 * Verdict navigation action to select the previous typed verdict in the Events 
 * tree in the Events page of the Test Log Viewer.
 * 
 * 
 * @author      Bianca Xue Jiang 
 * @author      Paul E. Slauenwhite
 * @version     July 11, 2008
 * @since       September 14, 2005
 */
public class VerdictPreviousAction extends VerdictNavigationAction {

	public VerdictPreviousAction(VerdictTypesPullDownAction verdictTypesAction,	ITestLogVerdictTraversal collection, StructuredViewer structuredViewer) 
	{
		super(verdictTypesAction, collection, structuredViewer);
		setToolTipText(UiPluginResourceBundle.TestLogViewer_NavigatePrevious); 
		setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("e", TestUIImages.IMG_VERDICT_NAV_PREV));
		setDisabledImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("d", TestUIImages.IMG_VERDICT_NAV_PREV));
	}

	protected boolean updateSelection(IStructuredSelection selection) {

		if(!super.updateSelection(selection)){
			return false;
		}
		
		Object element = selection.getFirstElement();

		if(element != null){		
			
			if(element instanceof TPFVerdictEvent){
				return (verdictCollection.hasPrevious(getCurrentVerdictType(), element));	
			}
			else{

				//Since the TestLogVerdictTraversalQuery does not support iterating non-TPFVerdictEvent events, disable the previous action:
				return false;	
			}
		}

		return true;
	}
	
	public void run() {
		TPFVerdictEvent event = verdictCollection.getPrevious(getCurrentVerdictType(), getStructuredSelection().getFirstElement());
		if(event != null) {
			VerdictNavigationAction.revealEvent(event, (TreeViewer) getStructuredViewer());
		}
	}
}
