/********************************************************************** 
 * Copyright (c) 2005, 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: ExecutionEventDetailsProvider.java,v 1.8 2008/07/09 18:50:05 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.ui.forms.base;

import java.util.Enumeration;
import java.util.Hashtable;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFLoopEvent;
import org.eclipse.hyades.models.common.testprofile.TPFMessageEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTimedEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.models.common.testprofile.TPFWaitEvent;
import org.eclipse.hyades.test.ui.internal.editor.form.util.ExecutionHistoryExtensionsManager;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.editor.FormPage;

/**
 * This class is an {@link org.eclipse.ui.forms.IDetailsPageProvider IDetailsPageProvider} to provide
 * proper details page of the page book based on execution event type in the TPTP Test Log Viewer.
 *
 * 
 * @author      Paul E. Slauenwhite
 * @author      Bianca Xue Jiang 
 * @version     July 9, 2008
 * @since       August 9, 2005
 */
public class ExecutionEventDetailsProvider implements IDetailsPageProvider
{
	private FormPage formPage;
	private Hashtable defaultPages;

	/**
	 * Creates an instance of this class with the editor page.
	 * @param page forms editor page of this part.
	 */
	public ExecutionEventDetailsProvider(FormPage page)
	{		
		this.formPage = page;
		buildDefaultPages(page);
	}
	
	private void buildDefaultPages(FormPage page)
	{
		defaultPages = new Hashtable();

		//For TPFExecutonResults:
		defaultPages.put(TPFExecutionResult.class, new ExecutionResultEventDetailsPart(page));		
		
		//For TPFExecutionEvents:
		defaultPages.put(TPFTypedEvent.class, new TypedEventDetailsPart(page));
		defaultPages.put(TPFMessageEvent.class, new MessageEventDetailsPart(page));
		defaultPages.put(TPFInvocationEvent.class, new InvocationEventDetailsPart(page));
		defaultPages.put(TPFVerdictEvent.class, new VerdictEventDetailsPart(page));
		defaultPages.put(TPFLoopEvent.class, new LoopEventDetailsPart(page));
		defaultPages.put(TPFTimedEvent.class, new TimedEventDetailsPart(page));
		defaultPages.put(TPFWaitEvent.class, new TimedEventDetailsPart(page));
	}

	public Object getPageKey(Object object)
	{
		//When there is details page extensions registered for this event type, pages go by event instances. 
		//This is more memory consuming so max. pages cached is set to LogEventsBlock.DETAILS_PAGE_CACHE_SIZE. 
		if(object instanceof EObject && 
			ExecutionHistoryExtensionsManager.getInstance().getEventDetailsPage((EObject)object) != null)				
				return object;

		//Optimization
		//when there is no extension based on event type, pages go by event class.
		return object.getClass();
	}

	public IDetailsPage getPage(Object key)
	{
		IDetailsPage page = null;
		if(key instanceof EObject)
		{
			// Lookup for a details page from extensions for this specific event type first.
			page = ExecutionHistoryExtensionsManager.getInstance().getEventDetailsPage((EObject)key);
			if(page != null)
			{
				if(page instanceof ExecutionEventDetailsPart)
					((ExecutionEventDetailsPart)page).setFormPage(formPage);
				return page;
			}
		}
		
		// Lookup for the default detail page	
		Class eventClass = (key instanceof Class) ? (Class)key : key.getClass();
		page = (IDetailsPage)defaultPages.get(eventClass);
		if(page != null)
			return page;
		
		Enumeration keys = defaultPages.keys();
		while(keys.hasMoreElements())
		{
			Object element = keys.nextElement();
			if(element instanceof Class)
			{
				if(((Class)element).isAssignableFrom(eventClass))
					return (IDetailsPage)defaultPages.get(element);
			}
		}
		
		return null;
	}
}
