/********************************************************************** 
 * Copyright (c) 2005, 2007 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: InvocationEventDetailsPart.java,v 1.6 2007/03/22 14:42:04 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.ui.forms.base;

import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

/**
 * This is the details page of the page book used for {@link org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent TPFInvocationEvent}
 * in the events tree of Test Log Viewer.
 * 
 * <p>This is a eclipse forms page derived from the original TPTP Test Log viewer</p>
 * 
 * @author bjiang
 * @author marcelop
 * @since  4.1
 */
public class InvocationEventDetailsPart extends ExecutionEventDetailsPart
{
	private Text statusText;
	//private Text reasonText;
	
	public InvocationEventDetailsPart()
	{
		super();
	}

	/**
	 * Creates an instance of this class with the editor page.
	 * @param page forms editor page of this part.
	 */
	public InvocationEventDetailsPart(FormPage page)
	{
		super(page);
	}

	protected void createDetailsContents(Composite parent)
	{		
		FormToolkit toolkit = getManagedForm().getToolkit();
		toolkit.createLabel(parent, UiPluginResourceBundle.LBL_STATUS); 
		statusText = toolkit.createText(parent, "", SWT.FULL_SELECTION | SWT.SINGLE);
		//statusText.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB));
		statusText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		statusText.setEditable(false);

		toolkit.paintBordersFor(parent);
	}
	
	protected void setInput(Object object)
	{
		super.setInput(object);
		
		if(object instanceof TPFInvocationEvent)
		{
			TPFInvocationEvent invocationEvent = (TPFInvocationEvent)object;
			
			if(invocationEvent.getStatus() != null)
				statusText.setText(invocationEvent.getStatus().getLabel());
			else
				statusText.setText(""); //$NON-NLS-1$

			/*if(invocationEvent.getReason() != null)
				reasonText.setText(invocationEvent.getReason().getLabel());
			else
				reasonText.setText(""); //$NON-NLS-1$*/		
		}
		else
		{
			statusText.setText(""); //$NON-NLS-1$
			//reasonText.setText(""); //$NON-NLS-1$
		}			
	}
}
