/********************************************************************** 
 * Copyright (c) 2006, 2009 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: LogOverviewDetailsPart.java,v 1.9 2009/04/07 17:53:31 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.ui.forms.base;

import java.util.List;

import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.test.ui.forms.editor.page.LogEventsPage;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.VerdictCategory;
import org.eclipse.hyades.test.ui.forms.util.FormsUtil;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EventLabelProvider;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;

/**
 * <p>Details part in Test Log Viewer Overview page.</p>
 * 
 * 
 * @author  Bianca Xue Jiang
 * @author  Paul E. Slauenwhite
 * @version April 7, 2009
 * @since   March 15, 2006
 */
public class LogOverviewDetailsPart extends ExecutionResultDetailsPart implements ISelectionChangedListener
{
	private SashForm parentSash;
	private Section verdictListSection;
	private ILabelProvider eventLabelProvider;
	private VerdictCategory currentVerdictCategory;
	
	protected static int MAX_VERDICT_NUMBER = 20;
	
	public LogOverviewDetailsPart(FormPage page)
	{
		super(page);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.forms.IDetailsPage#createContents(org.eclipse.swt.widgets.Composite)
	 */
	public void createContents(Composite parent)
	{
		parentSash = new SashForm(parent, SWT.VERTICAL);
		toolkit.adapt(parentSash, false, false);
		parentSash.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		createCommonPropSection(parentSash);		
		createVerdictListSection(parentSash);
		parentSash.setWeights(new int[]{35, 65});
		mForm.addPart(this);
	}
	
	public SashForm getParent()
	{
		return parentSash;
	}
	
	protected void createVerdictListSection(Composite parent)
	{
		verdictListSection = FormsUtil.createSection(mForm, parent, UiPluginResourceBundle.LogOverview_VerdictListTitle, UiPluginResourceBundle.LogOverview_VerdictListDescription); 

		GridLayout gridLayout = new GridLayout(2,false);
		gridLayout.marginWidth = 0;
		gridLayout.marginTop = 0;
		
		Composite client = (Composite)verdictListSection.getClient();
		client.setLayout(gridLayout);
		client.setLayoutData(GridDataUtil.createFill());
				
		toolkit.paintBordersFor(client);
	}
	
	public Section getVerdictListSection()
	{
		return verdictListSection;
	}
	
	protected ILabelProvider getVerdictEventLabelProvider()
	{
		if(eventLabelProvider == null)
			eventLabelProvider = new EventLabelProvider();
		
		return eventLabelProvider;
	}
	
	public void setInput(VerdictCategory category){
		
		Composite verdictListSectionClient = ((Composite)(verdictListSection.getClient()));
		
		if(category == null){
			
			//Update the description in the section:
			((FormText)(verdictListSection.getDescriptionControl())).setText(UiPluginResourceBundle.LogOverview_NoVerdictInLog, false, false);

			//Remove the verdict links and More... button from section:
			Control[] children = verdictListSectionClient.getChildren();
			
			if(children != null){
				
				for(int counter = 0;counter < children.length;counter++){
					
					children[counter].dispose();
					children[counter] = null;
				}
			}
		}
		else if((currentVerdictCategory == null) || (!currentVerdictCategory.equals(category))){
			
			currentVerdictCategory = category;
			
			//Remove the verdict links and More... button from section:
			Control[] children = verdictListSectionClient.getChildren();
			
			if(children != null){
				
				for(int counter = 0;counter < children.length;counter++){
					
					children[counter].dispose();
					children[counter] = null;
				}
			}
			
			GridLayout gridLayout = new GridLayout();
			gridLayout.marginTop = 0;
			
			Composite verdictListComposite = toolkit.createComposite(verdictListSectionClient);
			verdictListComposite.setLayout(gridLayout);
			verdictListComposite.setLayoutData(GridDataUtil.createFill());	
			
			List verdicts = category.getVerdicts();
			int size = Math.min(category.getNumVerdicts(), MAX_VERDICT_NUMBER);
			
			for(int counter = 0;counter < size;counter++){
				
				if (!category.isIgnoredVerdict(counter)){

					String eventText = getVerdictEventLabelProvider().getText(verdicts.get(counter));

					ImageHyperlink hyperlink = toolkit.createImageHyperlink(verdictListComposite, SWT.NONE);
					hyperlink.setData(verdicts.get(counter));
					hyperlink.addHyperlinkListener(this);
					hyperlink.setText(eventText);
					hyperlink.setToolTipText(eventText);
					hyperlink.setImage(category.getImage());
				}
			}

			Button moreButton = toolkit.createButton(verdictListSectionClient, UiPluginResourceBundle.ACT_MORE, SWT.PUSH); 
			moreButton.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END | GridData.VERTICAL_ALIGN_BEGINNING));
			moreButton.addSelectionListener(new SelectionAdapter(){
				
				/* (non-Javadoc)
				 * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
				 */
				public void widgetSelected(SelectionEvent s){
					formPage.getEditor().setActivePage(LogEventsPage.PAGE_ID);
				}
			});

			verdictListSectionClient.layout(true);
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.forms.events.IHyperlinkListener#linkActivated(org.eclipse.ui.forms.events.HyperlinkEvent)
	 */
	public void linkActivated(HyperlinkEvent e)
	{
//		 open Events page and select the verdict event
		if(e.widget instanceof ImageHyperlink && e.widget.getData() instanceof TPFVerdictEvent)
		{			
			formPage.getEditor().setActivePage(LogEventsPage.PAGE_ID);
			LogEventsPage page = (LogEventsPage) formPage.getEditor().getActivePageInstance();
			page.lazySelectVerdictEvent((TPFVerdictEvent) e.widget.getData());
		}
		else
			super.linkActivated(e);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
	 */
	public void selectionChanged(SelectionChangedEvent event) {
		if(event.getSource() instanceof VerdictSummaryChart)
		{
			Object sel = ((IStructuredSelection)event.getSelection()).getFirstElement();
			if(sel instanceof VerdictCategory)
				setInput((VerdictCategory)sel);
		}
	}
}
