/********************************************************************** 
 * Copyright (c) 2005, 2007 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: MessageEventDetailsPart.java,v 1.6 2007/03/22 14:42:04 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.ui.forms.base;

import org.eclipse.hyades.models.common.testprofile.TPFMessageEvent;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

/**
 * This is the details page of the page book used for {@link org.eclipse.hyades.models.common.testprofile.TPFMessageEvent TPFMessageEvent}
 * in the events tree of TPTP Test Log Viewer.
 * 
 * <p>This is a eclipse forms page derived from the original TPTP Test Log viewer</p>
 * 
 * @author bjiang
 * @author marcelop
 * @since  4.1
 */
public class MessageEventDetailsPart extends ExecutionEventDetailsPart
{
	private Text severityText;
	
	public MessageEventDetailsPart()
	{
		super();
	}

	/**
	 * Creates an instance of this class with the editor page.
	 * @param page forms editor page of this part.
	 */
	public MessageEventDetailsPart(FormPage page)
	{
		super(page);
	}

	protected void createDetailsContents(Composite parent)
	{
		FormToolkit toolkit = getManagedForm().getToolkit();
		toolkit.createLabel(parent, UiPluginResourceBundle.LBL_SEV); 
		severityText = toolkit.createText(parent, "", SWT.FULL_SELECTION | SWT.SINGLE);
		//severityText.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB));
		severityText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		severityText.setEditable(false);
		
		toolkit.paintBordersFor(parent);
	}
	
	protected void setInput(Object object)
	{
		super.setInput(object);
		
		if(object instanceof TPFMessageEvent)
		{
			if(((TPFMessageEvent)object).getSeverity() != null)
			{		
				severityText.setText(((TPFMessageEvent)object).getSeverity().getLabel());
			}						
		}
		else
			severityText.setText("");
	}
}
