/*******************************************************************************
 * Copyright (c) 2007, 2010 IBM Corporation and others. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SystemStyleProcessor.java,v 1.4 2010/06/01 14:14:11 jcayne Exp $
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/
package org.eclipse.hyades.test.ui.forms.base;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.StyledComponent;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.FontDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextAlignmentImpl;
import org.eclipse.birt.chart.style.IStyle;
import org.eclipse.birt.chart.style.IStyleProcessor;
import org.eclipse.birt.chart.style.SimpleStyle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

/**
 * @author  Jerome Bozier
 * @version June 1, 2010
 * @since 4.4.0
 * @provisional As of TPTP V4.4.0, this is stable provisional API (see http://www.eclipse.org/tptp/home/documents/process/development/api_contract.html).
 */
public class SystemStyleProcessor implements IStyleProcessor {

	/**
	 * Recalculates the system settings for font, foreground color and background color and returns a new
	 * style with the current system settings.
	 */
	public IStyle getStyle(Chart model, StyledComponent name) {
		
		if(name == null)
			return null;
		
		int component = name.getValue();
		if(model instanceof ChartWithoutAxes &&
			(component == StyledComponent.CHART_BACKGROUND ||
			 component == StyledComponent.PLOT_BACKGROUND ))
		{
			FontData systemFontData = Display.getCurrent().getSystemFont().getFontData()[0];
			FontDefinition sFont = FontDefinitionImpl.create(systemFontData.getName(), 
															 systemFontData.getHeight(), 
															 (systemFontData.getStyle() & SWT.BOLD) > 0, 
															 (systemFontData.getStyle() & SWT.ITALIC) > 0,
															 false, 
															 false, 
															 false, 
															 0, 
															 TextAlignmentImpl.create( ));
			
			Color foregroundColor = Display.getCurrent().getSystemColor(SWT.COLOR_LIST_FOREGROUND);
			ColorDefinition fgColor = ColorDefinitionImpl.create(foregroundColor.getRed(), foregroundColor.getGreen(), foregroundColor.getBlue());
			
			Color backgroundColor = Display.getCurrent().getSystemColor(SWT.COLOR_LIST_BACKGROUND);
			ColorDefinition bgColor = ColorDefinitionImpl.create(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue());
			
			return new SimpleStyle(sFont, fgColor, bgColor, null, null);
		}
		
		return null;
	}

	public void processStyle(Chart model) {
		// TODO : ... 
	}

	private ColorDefinition defaultBgColor = null;
	
	/**
	 * set default background color
	 */
	public void setDefaultBackgroundColor(ColorDefinition cd) {
		defaultBgColor = cd;
	}

	/**
	 * get default background color
	 * if not defined, use system one ad default
	 */
	public ColorDefinition getDefaultBackgroundColor() {
		if (defaultBgColor == null) {
			Color backgroundColor = Display.getCurrent().getSystemColor(SWT.COLOR_LIST_BACKGROUND);
			defaultBgColor = ColorDefinitionImpl.create(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue());			
		}
		return defaultBgColor;
	}

}
