/********************************************************************** 
 * Copyright (c) 2005, 2007 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: TypedEventDetailsPart.java,v 1.6 2007/03/22 14:42:04 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.ui.forms.base;

import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

/**
 * This is the details page of the page book used for {@link org.eclipse.hyades.models.common.testprofile.TPFTypedEvent TPFTypedEvent}
 * in the events tree of TPTP Test Log Viewer.
 * 
 * <p>This is a eclipse forms page derived from the original TPTP Test Log viewer</p>
 * 
 * @author bjiang
 * @author marcelop
 * @since  4.1
 */
public class TypedEventDetailsPart extends ExecutionEventDetailsPart
{
	private Text typeText;
	
	public TypedEventDetailsPart()
	{
		super();
	}
	
	/**
	 * Creates an instance of this class with the editor page.
	 * @param page forms editor page of this part.
	 */
	public TypedEventDetailsPart(FormPage page)
	{
		super(page);
	}
	
	protected void createDetailsContents(Composite parent)
	{	
		FormToolkit toolkit = getManagedForm().getToolkit();
		toolkit.createLabel(parent, UiPluginResourceBundle.LBL_TYPE); 
		typeText = toolkit.createText(parent, "", SWT.FULL_SELECTION | SWT.SINGLE);
		//typeText.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB));
		typeText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		typeText.setEditable(false);
		
		toolkit.paintBordersFor(parent);
	}

	protected void setInput(Object object)
	{
		super.setInput(object);
		
		if(object instanceof TPFTypedEvent)
		{
			if(((TPFTypedEvent)object).getType() != null)
			{		
				typeText.setText(((TPFTypedEvent)object).getType().getLabel());
			}						
		}
		else
			typeText.setText("");
	}
}
