/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestLogViewer.java,v 1.11 2008/07/24 23:59:13 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.forms.editor;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.test.ui.forms.base.TestLogVerdictTraversalQuery;
import org.eclipse.hyades.test.ui.forms.base.VerdictSummaryChart;
import org.eclipse.hyades.test.ui.forms.editor.page.LogEventsPage;
import org.eclipse.hyades.test.ui.forms.editor.page.LogOverviewPage;
import org.eclipse.hyades.test.ui.forms.util.ITestLogVerdictTraversal;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.PartInitException;

/**
 * This is the Eclipse forms TPTP Test Log Viewer.
 * <p/>
 * This is an Eclipse forms class derived from the original TPTP Test Log Viewer.
 * <p/>
 * 
 * 
 * @author  Bianca Xue Jiang 
 * @author  Marcelo Paternostro
 * @author  Paul E. Slauenwhite
 * @version July 24, 2008
 * @since   August 9, 2005
 */
public class TestLogViewer extends BaseFormEditor {
	
	private LogOverviewPage overviewPage;
	private LogEventsPage eventsPage;
	private TestLogVerdictTraversalQuery testLogVerdictTraversal;
	
	public TestLogViewer()
	{
		super(TPFExecutionResult.class);
	}

	/*
	 *  (non-Javadoc)
	 * @see org.eclipse.ui.forms.editor.FormEditor#addPages()
	 */
	protected void addPages() {
		try {
			testLogVerdictTraversal = new TestLogVerdictTraversalQuery((TPFExecutionResult) getEditorObject()); 
			overviewPage = new LogOverviewPage(this);
			eventsPage = new LogEventsPage(this);
			int index = addPage(overviewPage);
			addPage(eventsPage);
			setActivePage(index);
		}
		catch (PartInitException e) {
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.forms.editor.BaseFormEditor#reloadEditorObject()
	 */
	public boolean reloadEditorObject(){
		
		if(!super.reloadEditorObject()){
			
			//Resolve the editor object (TPFExecutionResult):
			TPFExecutionResult editorObject = ((TPFExecutionResult)(getEditorObject()));
			
			//Reset the editor object (TPFExecutionResult) for the TestLogVerdictTraversalQuery:
			testLogVerdictTraversal.init(editorObject);
			
			//If the verdict summary chart exists, reset the editor object (TPFExecutionResult):
			VerdictSummaryChart verdictSummaryChart = overviewPage.getVerdictSummaryChart();
			
			if(verdictSummaryChart != null){
				verdictSummaryChart.setInput(editorObject, testLogVerdictTraversal);
			}
			
			return false;
		}
		
		return true;
	}
	
	/*
	 * (non-Javadoc)
	 * @see org.eclipse.hyades.ui.adapter.ISynchronizedEditorAdapter#editorFileChanged()
	 */
	public boolean editorFileChanged() {
		super.editorFileChanged();
		/*if(getActivePageInstance() == eventsPage)
		{
			if(getSelection().isEmpty())
			{
				try
				{
					setSelection(new StructuredSelection(getExecution().getExecutionHistory().getExecutionEvents().get(0)));
				}
				catch (RuntimeException e)
				{
				}
			}
		}*/
		return true;
	}
	
	public ISelection getSelection() {
		
		ISelection selection = null;
		
		if(getActivePageInstance() == eventsPage){
			selection = eventsPage.getSelection();
		}

		if((selection == null) || (selection.isEmpty())){
			selection = new StructuredSelection(getEditorObject());			
		}
		
		return selection;
	}
	
	public void setSelection(ISelection selection) {
		
		if(getActivePageInstance() == eventsPage){
			eventsPage.setSelection(selection);
		}
	}

	/**
	 * @provisional As of TPTP V4.4.0, this is stable provisional API (see http://www.eclipse.org/tptp/home/documents/process/development/api_contract.html).
	 */
	public ITestLogVerdictTraversal getTestLogVerdictTraversal() {
		return testLogVerdictTraversal;
	}
}
