/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LogEventsPage.java,v 1.13 2007/06/04 13:58:51 jptoomey Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.forms.editor.page;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.test.ui.forms.actions.VerdictNavigationAction;
import org.eclipse.hyades.test.ui.forms.base.LogEventsBlock;
import org.eclipse.hyades.test.ui.forms.editor.BaseFormEditor;
import org.eclipse.hyades.test.ui.forms.editor.TestLogViewer;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;

/**
 * This is the <i>Events</i> page class of the TPTP Test Log Viewer.
 * 
 * <p>This is a eclipse forms class derived from the original TPTP Test Log viewer</p>
 * 
 * @author bjiang
 * @author marcelop
 * @since  4.1
 */
public class LogEventsPage extends FormPage implements ISelectionProvider{
	
	private ScrolledForm form;
	public static final String PAGE_ID = "org.eclipse.tptp.test.ui.logviewer.events";
	
	private LogEventsBlock block;
	
	public LogEventsPage(FormEditor editor) {
		super(editor, PAGE_ID, UiPluginResourceBundle.W_EVENTS);
		block = new LogEventsBlock(this);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.forms.editor.FormPage#createFormContent(org.eclipse.ui.forms.IManagedForm)
	 */
	protected void createFormContent(IManagedForm managedForm) {
		form = managedForm.getForm();		
		form.setText(UiPluginResourceBundle.W_TEST_LOG);
		
		block.createContent(managedForm);
		managedForm.setInput(((BaseFormEditor)getEditor()).getEditorObject());

		// notify the editor's selectionChangeListeners of the selection change.   
		addSelectionChangedListener(new ISelectionChangedListener(){
			public void selectionChanged(SelectionChangedEvent event) {
				SelectionChangedEvent ev = new SelectionChangedEvent(LogEventsPage.this, event.getSelection());
				((TestLogViewer)getEditor()).fireSelectionChanged(ev);
			}
		});
	}	
	
	public void addSelectionChangedListener(ISelectionChangedListener listener)
	{
		block.addEventsSelectionChangedListener(listener);
	}
	
	public void removeSelectionChangedListener(ISelectionChangedListener listener)
	{
		block.removeEventsSelectionChangedListener(listener);
	}
	
	public boolean selectReveal(Object object)
	{
		if(object instanceof TPFExecutionHistory)
			object = ((TPFExecutionHistory)object).getExecutionResult();
		if(object instanceof TPFExecutionResult)
		{
			if(((TPFExecutionResult)object).eContainer() == null) //root level result, should reveal overview page.
				return false;
		}
			
		if(getEditor().getActivePageInstance() != this)
			getEditor().setActivePage(PAGE_ID);
		TreeViewer viewer = block.getTreeViewer();
		if(viewer != null)
		{
			viewer.reveal(object);
			viewer.setSelection(new StructuredSelection(object));
			viewer.getTree().forceFocus();
			return true;
		}
		
		return false;
	}
	
	public ISelection getSelection()
	{
		return block.getTreeViewer().getSelection();
	}
	
	public void setSelection(ISelection selection)
	{
		block.getTreeViewer().setSelection(selection);
	}
	
	/**
	 * @provisional As of TPTP V4.4.0, this is stable provisional API (see http://www.eclipse.org/tptp/home/documents/process/development/api_contract.html).
	 */
	public void lazySelectVerdictEvent(TPFVerdictEvent event) {
		if (event != null) {
			VerdictNavigationAction.revealEvent(event, block.getTreeViewer());
		}
	}
}
