/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IEventAction.java,v 1.4 2006/02/16 20:02:32 bjiang Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.forms.extensions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;

/**
 * This interface defines an action whose status depends on selection changes. Used in extension point
 * <b>"org.eclipse.hyades.test.ui.executionHistoryExtension.actionExtension"</b> for adding actions for execution events in
 * Test Log Viewer. 
 *  
 * @provisional
 * @see extension point "org.eclipse.hyades.test.ui.executionHistoryExtension"
 * @author bjiang
 * @since 4.2
 */
public interface IEventAction extends IAction, ISelectionChangedListener {
	
	/**
	 * If your extension of "org.eclipse.hyades.test.ui.executionHistoryExtension actionExtension" is defined "asButton",
	 * this method will be called and the return value will be used to set the enable/disable status of the button.
	 *  
	 * @return <code>true</code> if the button of this action should be enabled on current selection, or <code>false</code> otherwise.
	 */
	public boolean updateButtonStatus();
	
	/**
	 * <p>If your extension of "org.eclipse.hyades.test.ui.executionHistoryExtension actionExtension" is defined "asContextMenu",
	 * this method will be called right before the context menu is about to show. Because the context menu will be dynamically built every time
	 * based on the current selection, the extension implementing class should decide whether to add this action to the context menu. 
	 * 
	 * To add, simply do: <br>
	 * <code>manager.add(this);</code><br>
	 * 
	 * The enablement state of this action <code>isEnabled()</code> decides whether the menu item is enabled or not.</p>
	 */
	public void menuAboutToShow(IMenuManager manager);
}
