/********************************************************************** 
 * Copyright (c) 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: IPropertyLabelProvider.java,v 1.2 2006/04/21 15:18:43 bjiang Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.ui.forms.extensions;

import org.eclipse.hyades.models.common.common.CMNDefaultProperty;

/**
 * Defines a lable provider for execution event propreties 
 * {@link org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent#getProperties()}
 * 
 * @since 4.2
 * @author bjiang
 * @see extension point <i>org.eclipse.hyades.test.ui.executionHistoryExtension</i>
 */
public interface IPropertyLabelProvider {
	
	/**
	 * Returns the display name of the specified property.
	 * @param property
	 */
	public String getName(CMNDefaultProperty property);
	
	/**
	 * Returns the display value of the specified property.
	 * @param property
	 */
	public String getValue(CMNDefaultProperty property);

	
	/**
	 * Returns the display value of the specified property when <i>unit</i> attribute is specified in the extension.
	 * @param property
	 */
	public String getValue(CMNDefaultProperty property, String unit);
}
