/********************************************************************** 
 * Copyright (c) 2006, 2009 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: DefaultVerdictCategoryProvider.java,v 1.4 2009/02/20 17:49:22 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.ui.forms.extensions.provisional;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictList;
import org.eclipse.hyades.test.ui.TestUIConstants;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.forms.base.TestLogVerdictTraversalQuery;
import org.eclipse.hyades.test.ui.forms.util.ITestLogVerdictTraversal;
import org.eclipse.swt.graphics.RGB;

/**
 * This is a default {@link IVerdictCategoryProvider} used for verdict summary in Test Log Viewer.
 * 
 * 
 * @author  Bianca Xue Jiang
 * @author  Paul Slauenwhite
 * @version February 20, 2009
 * @since   March 15, 2006
 */
public class DefaultVerdictCategoryProvider implements IVerdictCategoryProvider {
	
	/**
	 * @deprecated As of TPTP 4.5.3, use {@link TestUIConstants#COLOR_PASS}.
	 */
	public static final RGB COLOR_PASS = TestUIConstants.COLOR_PASS;

	/**
	 * @deprecated As of TPTP 4.5.3, use {@link TestUIConstants#COLOR_FAIL}.
	 */
	public static final RGB COLOR_FAIL = TestUIConstants.COLOR_FAIL;
	
	/**
	 * @deprecated As of TPTP 4.5.3, use {@link TestUIConstants#COLOR_ERROR}.
	 */
	public static final RGB COLOR_ERROR = TestUIConstants.COLOR_ERROR;
	
	/**
	 * @deprecated As of TPTP 4.5.3, use {@link TestUIConstants#COLOR_INCONCLUSIVE}.
	 */
	public static final RGB COLOR_INCONCLUSIVE = TestUIConstants.COLOR_INCONCLUSIVE;

	public VerdictCategory[] getVerdictCategories(List allVerdictEvents) {
		if(allVerdictEvents == null || allVerdictEvents.size() == 0)
			return null;
	return getVerdictCategories(((TPFExecutionEvent) allVerdictEvents.get(0)).getExecutionHistory().getExecutionResult());
	}

	public VerdictCategory[] getVerdictCategories(TPFExecutionResult executionResult) {
		List lists = executionResult.getVerdictLists();
		if(lists == null || lists.isEmpty())
			return null;
		
		List categories = new ArrayList();
		TPFVerdictList defCategory = null;
		List events;
		for(Iterator it = lists.iterator(); it.hasNext();)
		{
			defCategory = (TPFVerdictList)it.next();
			if(defCategory != null)
			{
				events = defCategory.getVerdictEvents();
				if(events != null && !events.isEmpty())
				{
					if(TPFVerdict.ERROR_LITERAL.getName().equals(defCategory.getType()))
					{
						categories.add(new VerdictCategory(events, TPFVerdict.ERROR_LITERAL.getLabel(), TestUIConstants.COLOR_ERROR, TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EVENT_VERDICT_ERROR)));					
					}
					else if(TPFVerdict.FAIL_LITERAL.getName().equals(defCategory.getType()))
					{
						categories.add(new VerdictCategory(events, TPFVerdict.FAIL_LITERAL.getLabel(), TestUIConstants.COLOR_FAIL, TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EVENT_VERDICT_FAIL)));
					} 
					else if(TPFVerdict.INCONCLUSIVE_LITERAL.getName().equals(defCategory.getType()))
					{
						categories.add(new VerdictCategory(events, TPFVerdict.INCONCLUSIVE_LITERAL.getLabel(), TestUIConstants.COLOR_INCONCLUSIVE, TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EVENT_VERDICT_INCONCLUSIVE)));
					}
					else if(TPFVerdict.PASS_LITERAL.getName().equals(defCategory.getType()))
					{
						categories.add(new VerdictCategory(events, TPFVerdict.PASS_LITERAL.getLabel(), TestUIConstants.COLOR_PASS, TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EVENT_VERDICT_PASS)));
					}
				}
			}
		}
		
		return (VerdictCategory[])categories.toArray(new VerdictCategory[categories.size()]);
	}
	
	public VerdictCategory getDefaultCategory(VerdictCategory[] categories) {
		if(categories == null)
			return null;
		
		VerdictCategory errorList = null;
		VerdictCategory failList = null;
		VerdictCategory inconclusiveList = null;
		VerdictCategory passList = null;
		for(int i = 0; i < categories.length; i++)
		{
			VerdictCategory defCategory = categories[i];
			if(defCategory != null && defCategory.getVerdicts() != null)
			{
				if(TPFVerdict.ERROR_LITERAL.getName().equals(defCategory.getText()))
						errorList = defCategory;
				else if(TPFVerdict.FAIL_LITERAL.getName().equals(defCategory.getText()))
						failList = defCategory;
				else if(TPFVerdict.INCONCLUSIVE_LITERAL.getName().equals(defCategory.getText()))
						inconclusiveList = defCategory;
				else if(TPFVerdict.PASS_LITERAL.getName().equals(defCategory.getText()))
						passList = defCategory;
			}
		}
		
		if(errorList != null && errorList.getNumVerdicts() > 0)
			return errorList;
		else if(failList != null && failList.getNumVerdicts() > 0)
			return failList;
		else if(inconclusiveList != null && inconclusiveList.getNumVerdicts() > 0)
			return inconclusiveList;
		else if(passList != null && passList.getNumVerdicts() > 0)
			return passList;
		else
			return null;
	}

	public VerdictCategory[] getVerdictCategories(ITestLogVerdictTraversal traversal) {
		VerdictCategory[] categories = new VerdictCategory[4];
		if (traversal instanceof TestLogVerdictTraversalQuery) {
			TestLogVerdictTraversalQuery query = (TestLogVerdictTraversalQuery) traversal;
			categories[0] = (new VerdictCategory(query.getQueryResults(TPFVerdict.ERROR), 
					TPFVerdict.ERROR_LITERAL.getLabel(), TestUIConstants.COLOR_ERROR, 
					TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EVENT_VERDICT_ERROR)));
			categories[1] = (new VerdictCategory(query.getQueryResults(TPFVerdict.FAIL), 
					TPFVerdict.FAIL_LITERAL.getLabel(), TestUIConstants.COLOR_FAIL, 
					TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EVENT_VERDICT_FAIL)));
			categories[2] = (new VerdictCategory(query.getQueryResults(TPFVerdict.INCONCLUSIVE), 
					TPFVerdict.INCONCLUSIVE_LITERAL.getLabel(), TestUIConstants.COLOR_INCONCLUSIVE, 
					TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EVENT_VERDICT_INCONCLUSIVE)));
			categories[3] = (new VerdictCategory(query.getQueryResults(TPFVerdict.PASS), 
					TPFVerdict.PASS_LITERAL.getLabel(), TestUIConstants.COLOR_PASS, 
					TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EVENT_VERDICT_PASS)));
			return categories;
		}
		else throw new UnsupportedOperationException();
	}
}
