/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IRecordRepositoryProvider.java,v 1.4 2007/05/02 19:35:48 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.forms.extensions.provisional;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;


/**
 * This interface defines a record repository provider used in 
 * extension point <i>org.eclipse.hyades.test.ui.testLogRepositoryRecordProvider</i>.
 * 
 * @see extension point <i>org.eclipse.hyades.test.ui.testLogRecordRepositoryProvider</i>
 * @author bjiang
 * @since 4.2
 */
public interface IRecordRepositoryProvider {
	
	/**
	 * Adds the specified listener that will be notified on repository record changes.
	 * @param listener
	 */
	public void addRecordListener(IRepositoryRecordListener listener);	
	/**
	 * Removes the specified listener that will be notified on repository record changes.
	 * @param listener
	 */
	public void removeRecordListener(IRepositoryRecordListener listener);
	
	/**
	 * Implements this method only if this provider wants to add UI inside the Test Log Viewer for selected
	 * <i>ExecutionEvent</i>. Otherwise, do nothing in the implementation.
	 * @param mForm
	 * @param parent
	 */
	public void createContent(IManagedForm mForm, Composite parent);
	
	/**
	 * When selection changes in test log viewer, this method will be invoked with the selected {@link TPFExecutionEvent}, 
	 * or <code>null</code> if the selection is not a {@link TPFExecutionEvent}.
	 * @param execEvent
	 */
	public void setInput(TPFExecutionEvent execEvent);
}
