/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IRepositoryRecordListener.java,v 1.1 2006/03/28 00:30:28 bjiang Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.forms.extensions.provisional;

import org.eclipse.hyades.models.common.testprofile.TPFRepositoryRecord;

/**
 * Classes implementing this interface should be notified with repository record changes if registered with a
 * {@link IRecordRepositoryProvider}.
 * 
 * @see IRecordRepositoryProvider
 * @see extension point <i>org.eclipse.hyades.test.ui.testLogRepositoryRecordProvider</i>
 * @author bjiang
 * @since 4.2
 */
public interface IRepositoryRecordListener {

	/**
	 * Sent when a new repository record is added.
	 * @param record
	 */
	public void recordAdded(TPFRepositoryRecord record);
	
	/**
	 * Sent when an existing repository record is removed.
	 * @param record
	 */
	public void recordRemoved(TPFRepositoryRecord record);
}
