/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ITestLogSearchProvider.java,v 1.4 2007/05/03 17:22:41 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.forms.extensions.provisional;

import java.util.Map;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.swt.widgets.Composite;

/**
 * Extensions that contribute to the search for elements in Test Log Search must implement this interface.
 * For examples, see {@link ExecutionEventSearchProvider}, {@link org.eclipse.hyades.test.ui.internal.search.VerdictEventSearchProvider}.
 * 
 * @see extension point "org.eclipse.hyades.test.ui.testLogSearchProvider"
 * @author bjiang
 * @since 4.2
 */
public interface ITestLogSearchProvider {

	/**
	 * This method will be called the first time the search element of this provider is selected.
	 * 
	 * @param parent
	 */
	public void createContents(Composite parent);
	
	/**
	 * If the search element of this provider is selected, this method will be invoked when the "Search"
	 * button is clicked to start searching. The implementation of this method should create a unique 
	 * {@link org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery SimpleSearchQuery} that
	 * can be used to search the particular element based on user's choices for it. 
	 * 
	 * @param rootObject an element in the test log that this search should start from  
	 * @param searchText the string that the user entered for searching. Depends on user's choices for the
	 * element of this provider, this string should be searched for in those fields of the element.
	 * @param options options include:<br>
	 * <li>name - {@link org.eclipse.hyades.test.ui.internal.search.TestLogSearchPage.SEARCH_OPTION_CASE_SENSITIVE}, value - Boolean</li>
	 * <li>name - {@link org.eclipse.hyades.test.ui.internal.search.TestLogSearchPage.SEARCH_OPTION_DEPTH}, value - Integer</li>
	 * @see org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery
	 */
	public SimpleSearchQuery createSearchQuery(EObject rootObject, String searchText, Map options);
	
	/**
	 * @see org.eclipse.search.ui.ISearchPage#setContainer(ISearchPageContainer)
	 * @param container
	 */
	public void setContainer(ISearchPageContainer container);
}
