/********************************************************************** 
 * Copyright (c) 2006, 2007 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: IVerdictCategoryProvider.java,v 1.3 2007/05/02 19:35:48 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.ui.forms.extensions.provisional;

import java.util.List;

import org.eclipse.hyades.test.ui.forms.util.ITestLogVerdictTraversal;

/**
 * This interface defines a provider that can categorize all verdict events from a test log (a.k.a. execution history).
 * The verdict categories will be used to draw the verdict summary chart on Test Log Viewer Overview page.
 *  
 * @see extension point org.eclipse.hyades.test.ui.executionHistoryExtension.verdictProvider
 * 
 * @author bjiang
 * @since 4.2
 */
public interface IVerdictCategoryProvider {

	public VerdictCategory[] getVerdictCategories(List allVerdictEvents);
	
	public VerdictCategory[] getVerdictCategories(ITestLogVerdictTraversal traversal);

	public VerdictCategory getDefaultCategory(VerdictCategory[] categories);
}
