/********************************************************************** 
 * Copyright (c) 2006, 2007 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: VerdictCategory.java,v 1.4 2007/05/03 17:23:07 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.ui.forms.extensions.provisional;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

/**
 * This class represents a category of {@link org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent} that has attributes like a category display <i>text</i>,
 * and a <i>color</i>. 
 * 
 * @author bjiang
 * @since 4.2
 */
public class VerdictCategory {

	private String text;
	private RGB color;
	private Image icon;
	private List verdictList;
	private List ignoredVerdictIndices;
	
	public VerdictCategory(){}
	
	public VerdictCategory(List verdictList, String text, RGB color, Image image)
	{
		this.verdictList = verdictList;
		this.text = text;
		this.color = color;
		this.icon = image;
		ignoredVerdictIndices = new ArrayList();
	}
	
	public VerdictCategory(List verdictList, String text, RGB color, Image image, List ignoredVerdictIndices) {
		this(verdictList, text, color, image);
		if (ignoredVerdictIndices != null)
			this.ignoredVerdictIndices = ignoredVerdictIndices;
	}
	
	/**
	 * @return the color
	 */
	public RGB getColor() {
		return color;
	}
	/**
	 * @param color the color to set
	 */
	public void setColor(RGB color) {
		this.color = color;
	}
	/**
	 * @return the text
	 */
	public String getText() {
		return text;
	}
	/**
	 * @param text the text to set
	 */
	public void setText(String text) {
		this.text = text;
	}
	
	public int getNumVerdicts() {
		return verdictList.size() - ignoredVerdictIndices.size();
	}
	
	public boolean isIgnoredVerdict(int index) {
		return ignoredVerdictIndices.contains(new Integer(index));
	}
	
	/**
	 * @return the verdicts
	 */
	public List getVerdicts() {
		return verdictList;
	}
	/**
	 * @param verdicts the verdicts to set
	 */
	public void setVerdicts(List verdictList) {
		this.verdictList = verdictList;
	}
	
	public void setImage(Image icon)
	{
		this.icon = icon;
	}
	
	public Image getImage()
	{
		return icon;
	}
}
