/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FormsUtil.java,v 1.4 2006/05/19 17:16:13 mddunn Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.forms.util;

import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

/**
 * This is a utility class to be used by ecipse forms based editors.
 * 
 * @author bjiang
 * @since  4.1
 */
public class FormsUtil {

	public FormsUtil() {}

	/**
	 * This method is used to create an eclipse forms {@link org.eclipse.ui.forms.widgets.Section Section}
	 * that can be commonly used by TPTP Test editors.  It uses
	 * {@link org.eclipse.swt.layout.GridLayout GridLayout} for <i>parent</i> and 
	 * for the <i>client</i> of the <i>section</i>.
	 * 
	 * @param managedForm the managed form this section is created for.
	 * @param parent parent composite of this section
	 * @param title title of this section
	 * @param description an description area will be created if the passed in <i>description</i> is not <code>null</code> or empty.
	 * @return a section with the specified <i>title</i> and <i>description</i> and a common layout.
	 */
	public static Section createSection(IManagedForm managedForm, Composite parent, String title, String description)
	{
		Layout layout = parent.getLayout();
		if(layout == null || !(layout instanceof GridLayout))
		{
			GridLayout gl = new GridLayout();
			gl.numColumns = 1;
			gl.marginTop = gl.marginHeight = gl.marginWidth = 0;
			gl.horizontalSpacing = 5;
			gl.verticalSpacing = 5;
			parent.setLayout(gl);
		}
		//parent.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_BLACK));
		
		FormToolkit toolkit = managedForm.getToolkit();
		final ScrolledForm form = managedForm.getForm();
		Section section = toolkit.createSection(parent,	Section.TWISTIE|Section.TITLE_BAR);
		section.setActiveToggleColor(toolkit.getHyperlinkGroup().getActiveForeground());
		section.setToggleColor(toolkit.getColors().getColor(FormColors.SEPARATOR));
		section.setText(title);
		section.setExpanded(true);
		section.addExpansionListener(new ExpansionAdapter() {
			public void expansionStateChanged(ExpansionEvent e) {
				form.reflow(false);
			}
		});
		section.setLayoutData(GridDataUtil.createHorizontalFill());
		section.marginHeight = 3;
		section.marginWidth = 3;
		section.clientVerticalSpacing = 5;
		//section.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_YELLOW));
		//section.setLayout(new GridLayout());
		
		if(description != null && description.trim().length() > 0)
		{
			FormText descriptionControl = toolkit.createFormText(section, false);
			descriptionControl.setText(description, false, false);
			section.setDescriptionControl(descriptionControl);
		}

		Composite client = toolkit.createComposite(section, SWT.NONE);
		//client.setLayoutData(GridDataUtil.createFill());
		//client.setLayout(new TableWrapLayout());
		client.setLayout(new GridLayout());
		//client.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_RED));
		section.setClient(client);
		
		return section;
	}
}
