/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ITestLogVerdictTraversal.java,v 1.6 2008/07/11 13:44:46 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.forms.util;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;

/**
 * ITestLogVerdictTraversal.java
 * 
 * 
 * @author      Jospeh P. Toomey
 * @author      Paul E. Slauenwhite
 * @version     July 11, 2008
 * @since       April 24, 2007
 * @provisional As of TPTP V4.4.0, this is stable provisional API (see http://www.eclipse.org/tptp/home/documents/process/development/api_contract.html).
 */
public interface ITestLogVerdictTraversal {

	/**
	 * Verdict type constant for all verdicts (value = 4).
	 */
	public static final int VERDICT_TYPE_ALL = 4;

	/**
	 * Determines if the verdict traversal contains one or more verdicts of the parameter verdict type.
	 * <p/>
	 * 
	 * @param verdictType The verdict type.
	 * @return True if the verdict traversal contains one or more verdicts of the parameter verdict type, otherwise false.
	 */
	public abstract boolean contains(int verdictType);

	/**
	 * Determines if a verdict of the specified type exists before the parameter or current verdict.
	 * <p/>
	 * If the parameter verdict is <code>null</code>, the current verdict is used.   
	 * <p/>
	 * 
	 * @param verdictType The verdict type.
	 * @param verdict The verdict, otherwise <code>null</code>.
	 * @return True if a verdict of the specified type exists before the parameter or current verdict, otherwise false.
	 */
	public abstract boolean hasPrevious(int verdictType, Object verdict);

	/**
	 * Determines if a verdict of the specified type exists after the parameter or current verdict.
	 * <p/>
	 * If the parameter verdict is <code>null</code>, the current verdict is used.   
	 * <p/>
	 * 
	 * @param verdictType The verdict type.
	 * @param verdict The verdict, otherwise <code>null</code>.
	 * @return True if a verdict of the specified type exists after the parameter or current verdict, otherwise false.
	 */
	public abstract boolean hasNext(int verdictType, Object verdict);

	/**
	 * Resolves the previous verdict of the specified type before the parameter or current verdict.
	 * <p/>
	 * If the parameter verdict is <code>null</code>, the current verdict is used.   
	 * <p/>
	 * 
	 * @param verdictType The verdict type.
	 * @param verdict The verdict, otherwise <code>null</code>.
	 * @return The previous verdict of the specified type before the parameter or current verdict, otherwise <code>null</code>.
	 */
	public abstract TPFVerdictEvent getPrevious(int verdictType, Object verdict);

	/**
	 * Resolves the next verdict of the specified type after the parameter or current verdict.
	 * <p/>
	 * If the parameter verdict is <code>null</code>, the current verdict is used.   
	 * <p/>
	 * 
	 * @param verdictType The verdict type.
	 * @param verdict The verdict, otherwise <code>null</code>.
	 * @return The next verdict of the specified type after the parameter or current verdict, otherwise <code>null</code>.
	 */
	public abstract TPFVerdictEvent getNext(int verdictType, Object verdict);

	/**
	 * Resolves the first verdict of the specified type.
	 * <p/>
	 * 
	 * @param verdictType The verdict type.
	 * @return The first verdict of the specified type, otherwise <code>null</code>.
	 */
	public abstract TPFVerdictEvent getFirst(int verdictType);

	/**
	 * Resolves the last verdict of the specified type.
	 * <p/>
	 * 
	 * @param verdictType The verdict type.
	 * @return The last verdict of the specified type, otherwise <code>null</code>.
	 */
	public abstract TPFVerdictEvent getLast(int verdictType);

	/**
	 * Resolves the execution result containing all of the verdicts.
	 * <p/>
	 * 
	 * @return The execution result containing all of the verdicts, otherwise <code>null</code>.
	 */
	public abstract TPFExecutionResult getExecutionResult();

}